/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import dagger.android.processor.AndroidMapKeys;
import dagger.android.processor.BaseProcessingStep;
import dagger.android.processor.XTypeNames;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.Set;
import javax.tools.Diagnostic;

final class AndroidMapKeyProcessingStep
extends BaseProcessingStep {
    private final XProcessingEnv processingEnv;

    AndroidMapKeyProcessingStep(XProcessingEnv processingEnv) {
        this.processingEnv = processingEnv;
    }

    public ImmutableSet<XClassName> annotationClassNames() {
        return ImmutableSet.of((Object)XTypeNames.ANDROID_INJECTION_KEY, (Object)XTypeNames.CLASS_KEY);
    }

    @Override
    public void process(XElement element, ImmutableSet<XClassName> annotationNames) {
        for (XClassName annotationName : annotationNames) {
            this.validateMethod(annotationName, XElements.asMethod(element));
        }
    }

    private void validateMethod(XClassName annotation, XMethodElement method) {
        XAnnotation suppressedWarnings;
        if (!Sets.union((Set)method.getAnnotationsAnnotatedWith(XTypeNames.QUALIFIER), (Set)method.getAnnotationsAnnotatedWith(XTypeNames.QUALIFIER_JAVAX)).isEmpty()) {
            return;
        }
        XType returnType = method.getReturnType();
        if (!this.factoryElement().getType().getRawType().isAssignableFrom(returnType.getRawType())) {
            return;
        }
        if (!(Sets.union((Set)method.getAnnotationsAnnotatedWith(XTypeNames.SCOPE), (Set)method.getAnnotationsAnnotatedWith(XTypeNames.SCOPE_JAVAX)).isEmpty() || (suppressedWarnings = method.getAnnotation(XTypeNames.SUPPRESS_WARNINGS)) != null && ImmutableSet.copyOf((Collection)suppressedWarnings.getAsStringList("value")).contains((Object)"dagger.android.ScopedInjectorFactory"))) {
            XAnnotation mapKeyAnnotation = (XAnnotation)Iterables.getOnlyElement((Iterable)method.getAnnotationsAnnotatedWith(XTypeNames.MAP_KEY));
            XTypeElement mapKeyValueElement = this.processingEnv.requireTypeElement(AndroidMapKeys.injectedTypeFromMapKey(mapKeyAnnotation).get());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("%s bindings should not be scoped. Scoping this method may leak instances of %s.", XTypeNames.ANDROID_INJECTOR_FACTORY.getCanonicalName(), mapKeyValueElement.getQualifiedName()), (XElement)method);
        }
        this.validateReturnType(method);
        if (method.hasAnnotation(XTypeNames.BINDS) && method.getParameters().size() == 1) {
            this.validateMapKeyMatchesBindsParameter(annotation, method);
        }
    }

    private void validateReturnType(XMethodElement method) {
        XType returnType = method.getReturnType();
        XType requiredReturnType = this.injectorFactoryOf(this.processingEnv.getWildcardType(null, null));
        if (!returnType.getTypeName().equals((Object)requiredReturnType.getTypeName())) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("%s should bind %s, not %s. See https://dagger.dev/android", method, XTypes.toStableString(requiredReturnType), XTypes.toStableString(returnType)), (XElement)method);
        }
    }

    private void validateMapKeyMatchesBindsParameter(XClassName annotationName, XMethodElement method) {
        XAnnotation annotation;
        XType mapKeyType;
        XType parameterType = ((XExecutableParameterElement)Iterables.getOnlyElement((Iterable)method.getParameters())).getType();
        if (!XTypes.isAssignableTo(parameterType, this.injectorFactoryOf(mapKeyType = this.processingEnv.requireTypeElement(AndroidMapKeys.injectedTypeFromMapKey(annotation = method.getAnnotation(annotationName)).get()).getType()))) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("%s does not implement AndroidInjector<%s>", XTypes.toStableString(parameterType), XTypes.toStableString(mapKeyType)), (XElement)method, annotation);
        }
    }

    private XType injectorFactoryOf(XType implementationType) {
        return this.processingEnv.getDeclaredType(this.factoryElement(), new XType[]{implementationType});
    }

    private XTypeElement factoryElement() {
        return this.processingEnv.requireTypeElement(XTypeNames.ANDROID_INJECTOR_FACTORY.getCanonicalName());
    }
}

