/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingStep;
import java.util.Map;
import java.util.Set;

public abstract class BaseProcessingStep
implements XProcessingStep {
    public final ImmutableSet<String> annotations() {
        return (ImmutableSet)this.annotationClassNames().stream().map(XClassName::getCanonicalName).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<XElement> process(XProcessingEnv env, Map<String, ? extends Set<? extends XElement>> elementsByAnnotation) {
        ImmutableSet.Builder deferredElements = ImmutableSet.builder();
        this.inverse(elementsByAnnotation).forEach((element, annotations) -> {
            try {
                this.process((XElement)element, (ImmutableSet<XClassName>)annotations);
            }
            catch (TypeNotPresentException e) {
                deferredElements.add(element);
            }
        });
        return deferredElements.build();
    }

    protected abstract void process(XElement var1, ImmutableSet<XClassName> var2);

    private ImmutableMap<XElement, ImmutableSet<XClassName>> inverse(Map<String, ? extends Set<? extends XElement>> elementsByAnnotation) {
        ImmutableMap annotationClassNames = (ImmutableMap)this.annotationClassNames().stream().collect(DaggerStreams.toImmutableMap(XClassName::getCanonicalName, className -> className));
        Preconditions.checkState((boolean)annotationClassNames.keySet().containsAll(elementsByAnnotation.keySet()), (String)"Unexpected annotations for %s: %s", (Object)this.getClass().getCanonicalName(), (Object)Sets.difference(elementsByAnnotation.keySet(), (Set)annotationClassNames.keySet()));
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        elementsByAnnotation.forEach((annotationName, elementSet) -> elementSet.forEach(element -> builder.put(element, (Object)((XClassName)annotationClassNames.get(annotationName)))));
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)builder.build().asMap(), ImmutableSet::copyOf));
    }

    protected abstract Set<XClassName> annotationClassNames();
}

