/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.graph.ImmutableNetwork;
import dagger.internal.codegen.binding.AutoValue_BindingGraph;
import dagger.internal.codegen.binding.AutoValue_BindingGraph_TopLevelBindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.LegacyBindingGraph;
import dagger.internal.codegen.binding.ResolvedBindings;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.model.BindingGraph;
import dagger.model.ComponentPath;
import dagger.model.Key;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@AutoValue
public abstract class BindingGraph {
    static BindingGraph create(ComponentPath componentPath, LegacyBindingGraph legacyBindingGraph, TopLevelBindingGraph topLevelBindingGraph) {
        return new AutoValue_BindingGraph(componentPath, legacyBindingGraph, topLevelBindingGraph);
    }

    BindingGraph() {
    }

    public abstract ComponentPath componentPath();

    abstract LegacyBindingGraph legacyBindingGraph();

    public abstract TopLevelBindingGraph topLevelBindingGraph();

    public boolean isFullBindingGraph() {
        return this.topLevelBindingGraph().isFullBindingGraph();
    }

    public ComponentDescriptor componentDescriptor() {
        return this.legacyBindingGraph().componentDescriptor();
    }

    public final ImmutableMap<Key, ResolvedBindings> contributionBindings() {
        return this.legacyBindingGraph().contributionBindings();
    }

    public final ImmutableMap<Key, ResolvedBindings> membersInjectionBindings() {
        return this.legacyBindingGraph().membersInjectionBindings();
    }

    public final ResolvedBindings resolvedBindings(BindingRequest request) {
        return this.legacyBindingGraph().resolvedBindings(request);
    }

    public final Iterable<ResolvedBindings> resolvedBindings() {
        return this.legacyBindingGraph().resolvedBindings();
    }

    public final TypeElement componentTypeElement() {
        return this.legacyBindingGraph().componentTypeElement();
    }

    public final ImmutableSet<TypeElement> ownedModuleTypes() {
        return this.legacyBindingGraph().ownedModuleTypes();
    }

    public final Optional<ExecutableElement> factoryMethod() {
        return this.legacyBindingGraph().factoryMethod();
    }

    public final ImmutableMap<ComponentRequirement, VariableElement> factoryMethodParameters() {
        return this.legacyBindingGraph().factoryMethodParameters();
    }

    public final ImmutableSet<ComponentRequirement> componentRequirements() {
        return this.legacyBindingGraph().componentRequirements();
    }

    public final ImmutableSet<ComponentDescriptor> componentDescriptors() {
        return this.legacyBindingGraph().componentDescriptors();
    }

    public ImmutableList<BindingGraph> subgraphs() {
        return (ImmutableList)this.legacyBindingGraph().subgraphs().stream().map(subgraph -> BindingGraph.create(this.componentPath().childPath(subgraph.componentDescriptor().typeElement()), subgraph, this.topLevelBindingGraph())).collect(DaggerStreams.toImmutableList());
    }

    @AutoValue
    static abstract class TopLevelBindingGraph
    extends dagger.model.BindingGraph {
        TopLevelBindingGraph() {
        }

        static TopLevelBindingGraph create(ImmutableNetwork<BindingGraph.Node, BindingGraph.Edge> network, boolean isFullBindingGraph) {
            return new AutoValue_BindingGraph_TopLevelBindingGraph(network, isFullBindingGraph);
        }

        public ImmutableSetMultimap<Class<? extends BindingGraph.Node>, ? extends BindingGraph.Node> nodesByClass() {
            return super.nodesByClass();
        }
    }
}

