/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.OptionalType;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.binding.ConfigurationAnnotations;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.RequestKind;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

public final class DependencyRequestFactory {
    private final KeyFactory keyFactory;
    private final InjectionAnnotations injectionAnnotations;
    private static final ImmutableSet<RequestKind> WRAPPING_MAP_VALUE_FRAMEWORK_TYPES = ImmutableSet.of((Object)RequestKind.PROVIDER, (Object)RequestKind.PRODUCER);

    @Inject
    DependencyRequestFactory(KeyFactory keyFactory, InjectionAnnotations injectionAnnotations) {
        this.keyFactory = keyFactory;
        this.injectionAnnotations = injectionAnnotations;
    }

    ImmutableSet<DependencyRequest> forRequiredResolvedVariables(List<? extends VariableElement> variables, List<? extends TypeMirror> resolvedTypes) {
        Preconditions.checkState((resolvedTypes.size() == variables.size() ? 1 : 0) != 0);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < variables.size(); ++i) {
            builder.add((Object)this.forRequiredResolvedVariable(variables.get(i), resolvedTypes.get(i)));
        }
        return builder.build();
    }

    ImmutableSet<DependencyRequest> forMultibindingContributions(Key multibindingKey, Iterable<ContributionBinding> multibindingContributions) {
        ImmutableSet.Builder requests = ImmutableSet.builder();
        for (ContributionBinding multibindingContribution : multibindingContributions) {
            requests.add((Object)this.forMultibindingContribution(multibindingKey, multibindingContribution));
        }
        return requests.build();
    }

    private DependencyRequest forMultibindingContribution(Key multibindingKey, ContributionBinding multibindingContribution) {
        Preconditions.checkArgument((boolean)multibindingContribution.key().multibindingContributionIdentifier().isPresent(), (String)"multibindingContribution's key must have a multibinding contribution identifier: %s", (Object)multibindingContribution);
        return DependencyRequest.builder().kind(this.multibindingContributionRequestKind(multibindingKey, multibindingContribution)).key(multibindingContribution.key()).build();
    }

    private RequestKind multibindingContributionRequestKind(Key multibindingKey, ContributionBinding multibindingContribution) {
        switch (multibindingContribution.contributionType()) {
            case MAP: {
                MapType mapType = MapType.from(multibindingKey);
                for (RequestKind kind : WRAPPING_MAP_VALUE_FRAMEWORK_TYPES) {
                    if (!mapType.valuesAreTypeOf(RequestKinds.frameworkClass(kind))) continue;
                    return kind;
                }
            }
            case SET: 
            case SET_VALUES: {
                return RequestKind.INSTANCE;
            }
            case UNIQUE: {
                throw new IllegalArgumentException("multibindingContribution must be a multibinding: " + multibindingContribution);
            }
        }
        throw new AssertionError((Object)multibindingContribution.toString());
    }

    DependencyRequest forRequiredResolvedVariable(VariableElement variableElement, TypeMirror resolvedType) {
        Preconditions.checkNotNull((Object)variableElement);
        Preconditions.checkNotNull((Object)resolvedType);
        Optional<AnnotationMirror> qualifier = this.injectionAnnotations.getQualifier(variableElement);
        return this.newDependencyRequest(variableElement, resolvedType, qualifier);
    }

    public DependencyRequest forComponentProvisionMethod(ExecutableElement provisionMethod, ExecutableType provisionMethodType) {
        Preconditions.checkNotNull((Object)provisionMethod);
        Preconditions.checkNotNull((Object)provisionMethodType);
        Preconditions.checkArgument((boolean)provisionMethod.getParameters().isEmpty(), (String)"Component provision methods must be empty: %s", (Object)provisionMethod);
        Optional<AnnotationMirror> qualifier = this.injectionAnnotations.getQualifier(provisionMethod);
        return this.newDependencyRequest(provisionMethod, provisionMethodType.getReturnType(), qualifier);
    }

    public DependencyRequest forComponentProductionMethod(ExecutableElement productionMethod, ExecutableType productionMethodType) {
        Preconditions.checkNotNull((Object)productionMethod);
        Preconditions.checkNotNull((Object)productionMethodType);
        Preconditions.checkArgument((boolean)productionMethod.getParameters().isEmpty(), (String)"Component production methods must be empty: %s", (Object)productionMethod);
        TypeMirror type = productionMethodType.getReturnType();
        Optional<AnnotationMirror> qualifier = this.injectionAnnotations.getQualifier(productionMethod);
        if (MoreTypes.isTypeOf(ListenableFuture.class, type)) {
            return DependencyRequest.builder().kind(RequestKind.FUTURE).key(this.keyFactory.forQualifiedType(qualifier, DaggerTypes.unwrapType(type))).requestElement((Element)productionMethod).build();
        }
        return this.newDependencyRequest(productionMethod, type, qualifier);
    }

    DependencyRequest forComponentMembersInjectionMethod(ExecutableElement membersInjectionMethod, ExecutableType membersInjectionMethodType) {
        Preconditions.checkNotNull((Object)membersInjectionMethod);
        Preconditions.checkNotNull((Object)membersInjectionMethodType);
        Optional<AnnotationMirror> qualifier = this.injectionAnnotations.getQualifier(membersInjectionMethod);
        Preconditions.checkArgument((!qualifier.isPresent() ? 1 : 0) != 0);
        TypeMirror membersInjectedType = (TypeMirror)Iterables.getOnlyElement(membersInjectionMethodType.getParameterTypes());
        return DependencyRequest.builder().kind(RequestKind.MEMBERS_INJECTION).key(this.keyFactory.forMembersInjectedType(membersInjectedType)).requestElement((Element)membersInjectionMethod).build();
    }

    DependencyRequest forProductionImplementationExecutor() {
        return DependencyRequest.builder().kind(RequestKind.PROVIDER).key(this.keyFactory.forProductionImplementationExecutor()).build();
    }

    DependencyRequest forProductionComponentMonitor() {
        return DependencyRequest.builder().kind(RequestKind.PROVIDER).key(this.keyFactory.forProductionComponentMonitor()).build();
    }

    DependencyRequest forSyntheticPresentOptionalBinding(Key requestKey, RequestKind kind) {
        Optional<Key> key = this.keyFactory.unwrapOptional(requestKey);
        Preconditions.checkArgument((boolean)key.isPresent(), (String)"not a request for optional: %s", (Object)requestKey);
        return DependencyRequest.builder().kind(kind).key(key.get()).isNullable(this.allowsNull(RequestKinds.getRequestKind(OptionalType.from(requestKey).valueType()), Optional.empty())).build();
    }

    private DependencyRequest newDependencyRequest(Element requestElement, TypeMirror type, Optional<AnnotationMirror> qualifier) {
        RequestKind requestKind = RequestKinds.getRequestKind(type);
        return DependencyRequest.builder().kind(requestKind).key(this.keyFactory.forQualifiedType(qualifier, RequestKinds.extractKeyType(type))).requestElement(requestElement).isNullable(this.allowsNull(requestKind, ConfigurationAnnotations.getNullableType(requestElement))).build();
    }

    private boolean allowsNull(RequestKind kind, Optional<DeclaredType> nullableType) {
        return nullableType.isPresent() || !kind.equals((Object)RequestKind.INSTANCE);
    }
}

