/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.BindingExpression;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.MethodBindingExpression;
import javax.lang.model.type.TypeMirror;

final class ComponentMethodBindingExpression
extends MethodBindingExpression {
    private final ComponentImplementation componentImplementation;
    private final ComponentDescriptor.ComponentMethodDescriptor componentMethod;

    ComponentMethodBindingExpression(BindingRequest request, ContributionBinding binding, MethodBindingExpression.MethodImplementationStrategy methodImplementationStrategy, BindingExpression wrappedBindingExpression, ComponentImplementation componentImplementation, ComponentDescriptor.ComponentMethodDescriptor componentMethod, DaggerTypes types) {
        super(request, binding, methodImplementationStrategy, wrappedBindingExpression, componentImplementation, types);
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
        this.componentMethod = (ComponentDescriptor.ComponentMethodDescriptor)Preconditions.checkNotNull((Object)componentMethod);
    }

    @Override
    protected CodeBlock getComponentMethodImplementation(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation component) {
        return componentMethod.equals(this.componentMethod) && component.equals(this.componentImplementation) ? this.methodBodyForComponentMethod(componentMethod) : super.getComponentMethodImplementation(componentMethod, component);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        Expression expression = super.getDependencyExpression(requestingClass);
        TypeMirror methodReturnType = this.componentMethod.methodElement().getReturnType();
        return methodReturnType.getKind().isPrimitive() ? Expression.create(methodReturnType, expression.codeBlock()) : expression;
    }

    @Override
    protected void addMethod() {
    }

    @Override
    protected String methodName() {
        return this.componentMethod.methodElement().getSimpleName().toString();
    }
}

