/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.validation.AnyBindingMethodValidator;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.shaded.auto.common.MoreElements;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;

public final class BindingMethodProcessingStep
extends TypeCheckingProcessingStep<ExecutableElement> {
    private final Messager messager;
    private final AnyBindingMethodValidator anyBindingMethodValidator;

    @Inject
    BindingMethodProcessingStep(Messager messager, AnyBindingMethodValidator anyBindingMethodValidator) {
        super(MoreElements::asExecutable);
        this.messager = messager;
        this.anyBindingMethodValidator = anyBindingMethodValidator;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return this.anyBindingMethodValidator.methodAnnotations();
    }

    @Override
    protected void process(ExecutableElement method, ImmutableSet<ClassName> annotations) {
        Preconditions.checkArgument((boolean)this.anyBindingMethodValidator.isBindingMethod(method), (String)"%s is not annotated with any of %s", (Object)method, this.annotations());
        if (!this.anyBindingMethodValidator.wasAlreadyValidated(method)) {
            this.anyBindingMethodValidator.validate(method).printMessagesTo(this.messager);
        }
    }
}

