/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import dagger.internal.codegen.validation.InjectValidator;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugin;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.spi.model.Binding;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DiagnosticReporter;
import javax.inject.Inject;

final class InjectBindingValidator
extends ValidationBindingGraphPlugin {
    private final InjectValidator injectValidator;

    @Inject
    InjectBindingValidator(InjectValidator injectValidator) {
        this.injectValidator = injectValidator.whenGeneratingCode();
    }

    public String pluginName() {
        return "Dagger/InjectBinding";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        bindingGraph.bindings().stream().filter(binding -> binding.kind().equals((Object)BindingKind.INJECTION)).forEach(binding -> this.validateInjectionBinding((Binding)binding, diagnosticReporter));
    }

    private void validateInjectionBinding(Binding node, DiagnosticReporter diagnosticReporter) {
        ValidationReport typeReport = this.injectValidator.validate(node.key().type().xprocessing().getTypeElement());
        for (ValidationReport.Item item : typeReport.allItems()) {
            diagnosticReporter.reportBinding(item.kind(), (BindingGraph.MaybeBinding)node, item.message());
        }
    }
}

