/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.compileroption.ProcessingOptions;
import dagger.internal.codegen.compileroption.ValidationType;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.validation.DiagnosticReporterFactory;
import dagger.internal.codegen.validation.Validation;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugin;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.BindingGraphPlugin;
import dagger.spi.model.DaggerProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.tools.Diagnostic;

public final class ValidationBindingGraphPlugins {
    private final ImmutableSet<ValidationBindingGraphPlugin> plugins;
    private final DiagnosticReporterFactory diagnosticReporterFactory;
    private final XProcessingEnv processingEnv;
    private final CompilerOptions compilerOptions;
    private final Map<String, String> processingOptions;

    @Inject
    ValidationBindingGraphPlugins(@Validation ImmutableSet<ValidationBindingGraphPlugin> plugins, DiagnosticReporterFactory diagnosticReporterFactory, XProcessingEnv processingEnv, CompilerOptions compilerOptions, @ProcessingOptions Map<String, String> processingOptions) {
        this.plugins = plugins;
        this.diagnosticReporterFactory = diagnosticReporterFactory;
        this.processingEnv = processingEnv;
        this.compilerOptions = compilerOptions;
        this.processingOptions = processingOptions;
    }

    public ImmutableSet<String> allSupportedOptions() {
        return (ImmutableSet)this.plugins.stream().flatMap(plugin -> plugin.supportedOptions().stream()).collect(DaggerStreams.toImmutableSet());
    }

    public void initializePlugins() {
        DaggerProcessingEnv daggerProcessingEnv = DaggerProcessingEnv.from((XProcessingEnv)this.processingEnv);
        this.plugins.forEach(plugin -> plugin.init(daggerProcessingEnv, (Map)this.pluginOptions((BindingGraphPlugin)plugin)));
    }

    private ImmutableMap<String, String> pluginOptions(BindingGraphPlugin plugin) {
        Set supportedOptions = plugin.supportedOptions();
        return supportedOptions.isEmpty() ? ImmutableMap.of() : ImmutableMap.copyOf((Map)Maps.filterKeys(this.processingOptions, supportedOptions::contains));
    }

    boolean visit(Optional<BindingGraph> prunedGraph, Supplier<BindingGraph> fullGraphSupplier) {
        BindingGraph graph = prunedGraph.isPresent() ? (BindingGraph)prunedGraph.get() : (BindingGraph)fullGraphSupplier.get();
        boolean isClean = true;
        ArrayList<ValidationBindingGraphPlugin> rerunPlugins = new ArrayList<ValidationBindingGraphPlugin>();
        for (ValidationBindingGraphPlugin plugin : this.plugins) {
            DiagnosticReporterFactory.DiagnosticReporterImpl reporter = this.createReporter(plugin.pluginName(), graph);
            plugin.visitGraph(graph, reporter);
            if (plugin.visitFullGraphRequested(graph)) {
                rerunPlugins.add(plugin);
            }
            if (!reporter.reportedDiagnosticKinds().contains((Object)Diagnostic.Kind.ERROR)) continue;
            isClean = false;
        }
        if (!rerunPlugins.isEmpty()) {
            BindingGraph fullGraph = (BindingGraph)fullGraphSupplier.get();
            for (ValidationBindingGraphPlugin plugin : rerunPlugins) {
                DiagnosticReporterFactory.DiagnosticReporterImpl reporter = this.createReporter(plugin.pluginName(), fullGraph);
                plugin.revisitFullGraph((BindingGraph)prunedGraph.get(), fullGraph, reporter);
                if (!reporter.reportedDiagnosticKinds().contains((Object)Diagnostic.Kind.ERROR)) continue;
                isClean = false;
            }
        }
        return isClean;
    }

    private DiagnosticReporterFactory.DiagnosticReporterImpl createReporter(String pluginName, BindingGraph graph) {
        boolean errorsAsWarnings = graph.isFullBindingGraph() && this.compilerOptions.fullBindingGraphValidationType().equals((Object)ValidationType.WARNING);
        return errorsAsWarnings ? this.diagnosticReporterFactory.reporterWithErrorAsWarnings(graph, pluginName) : this.diagnosticReporterFactory.reporter(graph, pluginName);
    }

    public void endPlugins() {
        this.plugins.forEach(BindingGraphPlugin::onPluginEnd);
    }
}

