/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.writing.GwtCompatibility;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.Key;
import dagger.spi.model.Scope;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

public final class FactoryGenerator
extends SourceFileGenerator<ProvisionBinding> {
    private final CompilerOptions compilerOptions;
    private final SourceFiles sourceFiles;

    @Inject
    FactoryGenerator(XFiler filer, CompilerOptions compilerOptions, SourceFiles sourceFiles, XProcessingEnv processingEnv) {
        super(filer, processingEnv);
        this.compilerOptions = compilerOptions;
        this.sourceFiles = sourceFiles;
    }

    @Override
    public XElement originatingElement(ProvisionBinding binding) {
        return binding.bindingElement().get();
    }

    @Override
    public ImmutableList<TypeSpec.Builder> topLevelTypes(ProvisionBinding binding) {
        Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        if (binding.kind() == BindingKind.DELEGATE) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)this.factoryBuilder(binding));
    }

    private TypeSpec.Builder factoryBuilder(ProvisionBinding binding) {
        TypeSpec.Builder factoryBuilder = TypeSpec.classBuilder((ClassName)SourceFiles.generatedClassNameForBinding(binding)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addTypeVariables(SourceFiles.bindingTypeElementTypeVariableNames(binding));
        if (binding.kind() == BindingKind.INJECTION || binding.kind() == BindingKind.ASSISTED_INJECTION || binding.kind() == BindingKind.PROVISION) {
            factoryBuilder.addAnnotation(this.scopeMetadataAnnotation(binding));
            factoryBuilder.addAnnotation(this.qualifierMetadataAnnotation(binding));
        }
        FactoryGenerator.factoryTypeName(binding).ifPresent(arg_0 -> ((TypeSpec.Builder)factoryBuilder).addSuperinterface(arg_0));
        this.addConstructorAndFields(binding, factoryBuilder);
        factoryBuilder.addMethod(this.getMethod(binding));
        this.addCreateMethod(binding, factoryBuilder);
        factoryBuilder.addMethod(InjectionMethods.ProvisionMethod.create(binding, this.compilerOptions));
        GwtCompatibility.gwtIncompatibleAnnotation(binding).ifPresent(arg_0 -> ((TypeSpec.Builder)factoryBuilder).addAnnotation(arg_0));
        return factoryBuilder;
    }

    private void addConstructorAndFields(ProvisionBinding binding, TypeSpec.Builder factoryBuilder) {
        if (FactoryCreationStrategy.of(binding) == FactoryCreationStrategy.SINGLETON_INSTANCE) {
            return;
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.constructorParams(binding).forEach(param -> {
            constructor.addParameter(param).addStatement("this.$1N = $1N", new Object[]{param});
            factoryBuilder.addField(FieldSpec.builder((TypeName)param.type, (String)param.name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        });
        factoryBuilder.addMethod(constructor.build());
    }

    private ImmutableList<ParameterSpec> constructorParams(ProvisionBinding binding) {
        ImmutableList.Builder params = ImmutableList.builder();
        this.moduleParameter(binding).ifPresent(arg_0 -> ((ImmutableList.Builder)params).add(arg_0));
        this.frameworkFields(binding).values().forEach(field -> params.add((Object)FactoryGenerator.toParameter(field)));
        return params.build();
    }

    private Optional<ParameterSpec> moduleParameter(ProvisionBinding binding) {
        if (binding.requiresModuleInstance()) {
            TypeName type = binding.bindingTypeElement().get().getType().getTypeName();
            return Optional.of(ParameterSpec.builder((TypeName)type, (String)"module", (Modifier[])new Modifier[0]).build());
        }
        return Optional.empty();
    }

    private ImmutableMap<DependencyRequest, FieldSpec> frameworkFields(ProvisionBinding binding) {
        UniqueNameSet uniqueFieldNames = new UniqueNameSet();
        this.moduleParameter(binding).ifPresent(module -> uniqueFieldNames.claim(module.name));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        SourceFiles.generateBindingFieldsForDependencies(binding).forEach((dependency, field) -> builder.put(dependency, (Object)FieldSpec.builder((TypeName)field.type(), (String)uniqueFieldNames.getUniqueName(field.name()), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build()));
        return builder.build();
    }

    private void addCreateMethod(ProvisionBinding binding, TypeSpec.Builder factoryBuilder) {
        MethodSpec.Builder createMethodBuilder = MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(SourceFiles.parameterizedGeneratedTypeNameForBinding(binding)).addTypeVariables(SourceFiles.bindingTypeElementTypeVariableNames(binding));
        switch (FactoryCreationStrategy.of(binding)) {
            case SINGLETON_INSTANCE: {
                FieldSpec.Builder instanceFieldBuilder = FieldSpec.builder((TypeName)SourceFiles.generatedClassNameForBinding(binding), (String)"INSTANCE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{SourceFiles.generatedClassNameForBinding(binding)});
                if (!SourceFiles.bindingTypeElementTypeVariableNames(binding).isEmpty()) {
                    instanceFieldBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0]));
                    createMethodBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0]));
                }
                ClassName instanceHolderName = SourceFiles.generatedClassNameForBinding(binding).nestedClass("InstanceHolder");
                createMethodBuilder.addStatement("return $T.INSTANCE", new Object[]{instanceHolderName});
                factoryBuilder.addType(TypeSpec.classBuilder((ClassName)instanceHolderName).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addField(instanceFieldBuilder.build()).build());
                break;
            }
            case CLASS_CONSTRUCTOR: {
                ImmutableList<ParameterSpec> params = this.constructorParams(binding);
                createMethodBuilder.addParameters(params);
                createMethodBuilder.addStatement("return new $T($L)", new Object[]{SourceFiles.parameterizedGeneratedTypeNameForBinding(binding), CodeBlocks.makeParametersCodeBlock(Lists.transform(params, input -> CodeBlock.of((String)"$N", (Object[])new Object[]{input})))});
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        factoryBuilder.addMethod(createMethodBuilder.build());
    }

    private MethodSpec getMethod(ProvisionBinding binding) {
        UniqueNameSet uniqueFieldNames = new UniqueNameSet();
        ImmutableMap<DependencyRequest, FieldSpec> frameworkFields = this.frameworkFields(binding);
        frameworkFields.values().forEach(field -> uniqueFieldNames.claim(field.name));
        ImmutableMap assistedParameters = (ImmutableMap)AssistedInjectionAnnotations.assistedParameters(binding).stream().collect(DaggerStreams.toImmutableMap(parameter -> parameter, parameter -> ParameterSpec.builder((TypeName)parameter.getType().getTypeName(), (String)uniqueFieldNames.getUniqueName(XElements.getSimpleName((XElement)parameter)), (Modifier[])new Modifier[0]).build()));
        TypeName providedTypeName = FactoryGenerator.providedTypeName(binding);
        MethodSpec.Builder getMethod = MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(providedTypeName).addParameters((Iterable)assistedParameters.values());
        if (FactoryGenerator.factoryTypeName(binding).isPresent()) {
            getMethod.addAnnotation(Override.class);
        }
        CodeBlock invokeNewInstance = InjectionMethods.ProvisionMethod.invoke(binding, request -> this.sourceFiles.frameworkTypeUsageStatement(CodeBlock.of((String)"$N", (Object[])new Object[]{frameworkFields.get(request)}), request.kind()), param -> ((ParameterSpec)assistedParameters.get((Object)param)).name, SourceFiles.generatedClassNameForBinding(binding), this.moduleParameter(binding).map(module -> CodeBlock.of((String)"$N", (Object[])new Object[]{module})), this.compilerOptions);
        if (binding.kind().equals((Object)BindingKind.PROVISION)) {
            binding.nullableType().map(XType::getTypeElement).map(XTypeElement::getClassName).ifPresent(arg_0 -> ((MethodSpec.Builder)getMethod).addAnnotation(arg_0));
            getMethod.addStatement("return $L", new Object[]{invokeNewInstance});
        } else if (!binding.injectionSites().isEmpty()) {
            CodeBlock instance = CodeBlock.of((String)"instance", (Object[])new Object[0]);
            getMethod.addStatement("$T $L = $L", new Object[]{providedTypeName, instance, invokeNewInstance}).addCode(InjectionMethods.InjectionSiteMethod.invokeAll(binding.injectionSites(), SourceFiles.generatedClassNameForBinding(binding), instance, binding.key().type().xprocessing(), arg_0 -> this.sourceFiles.frameworkFieldUsages(binding.dependencies(), frameworkFields).get(arg_0))).addStatement("return $L", new Object[]{instance});
        } else {
            getMethod.addStatement("return $L", new Object[]{invokeNewInstance});
        }
        return getMethod.build();
    }

    private AnnotationSpec scopeMetadataAnnotation(ProvisionBinding binding) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)TypeNames.SCOPE_METADATA);
        binding.scope().map(Scope::scopeAnnotation).map(DaggerAnnotation::className).map(ClassName::canonicalName).ifPresent(scopeCanonicalName -> builder.addMember("value", "$S", new Object[]{scopeCanonicalName}));
        return builder.build();
    }

    private AnnotationSpec qualifierMetadataAnnotation(ProvisionBinding binding) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)TypeNames.QUALIFIER_METADATA);
        Stream.concat(Stream.of(binding.key()), binding.provisionDependencies().stream().map(DependencyRequest::key)).map(Key::qualifier).flatMap(DaggerStreams.presentValues()).map(DaggerAnnotation::className).map(ClassName::canonicalName).distinct().forEach(qualifier -> builder.addMember("value", "$S", new Object[]{qualifier}));
        return builder.build();
    }

    private static TypeName providedTypeName(ProvisionBinding binding) {
        return binding.contributedType().getTypeName();
    }

    private static Optional<TypeName> factoryTypeName(ProvisionBinding binding) {
        return binding.kind() == BindingKind.ASSISTED_INJECTION ? Optional.empty() : Optional.of(TypeNames.factoryOf(FactoryGenerator.providedTypeName(binding)));
    }

    private static ParameterSpec toParameter(FieldSpec field) {
        return ParameterSpec.builder((TypeName)field.type, (String)field.name, (Modifier[])new Modifier[0]).build();
    }

    private static enum FactoryCreationStrategy {
        SINGLETON_INSTANCE,
        CLASS_CONSTRUCTOR;


        static FactoryCreationStrategy of(Binding binding) {
            switch (binding.kind()) {
                case DELEGATE: {
                    throw new AssertionError((Object)"Delegate bindings don't have a factory.");
                }
                case PROVISION: {
                    return binding.dependencies().isEmpty() && !binding.requiresModuleInstance() ? SINGLETON_INSTANCE : CLASS_CONSTRUCTOR;
                }
                case INJECTION: 
                case MULTIBOUND_SET: 
                case MULTIBOUND_MAP: {
                    return binding.dependencies().isEmpty() ? SINGLETON_INSTANCE : CLASS_CONSTRUCTOR;
                }
            }
            return CLASS_CONSTRUCTOR;
        }
    }
}

