/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.AutoValue_ComponentAnnotation;
import dagger.internal.codegen.base.ComponentCreatorAnnotation;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.Optional;

@AutoValue
public abstract class ComponentAnnotation {
    private static final ImmutableSet<ClassName> ROOT_COMPONENT_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.COMPONENT, (Object)TypeNames.PRODUCTION_COMPONENT);
    private static final ImmutableSet<ClassName> SUBCOMPONENT_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.SUBCOMPONENT, (Object)TypeNames.PRODUCTION_SUBCOMPONENT);
    private static final ImmutableSet<ClassName> ALL_COMPONENT_ANNOTATIONS = ImmutableSet.builder().addAll(ROOT_COMPONENT_ANNOTATIONS).addAll(SUBCOMPONENT_ANNOTATIONS).build();
    private static final ImmutableSet<ClassName> ALL_COMPONENT_AND_CREATOR_ANNOTATIONS = ImmutableSet.builder().addAll(ALL_COMPONENT_ANNOTATIONS).addAll(ComponentCreatorAnnotation.allCreatorAnnotations()).build();
    private static final ImmutableSet<ClassName> PRODUCTION_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.PRODUCTION_COMPONENT, (Object)TypeNames.PRODUCTION_SUBCOMPONENT, (Object)TypeNames.PRODUCER_MODULE);
    private XAnnotation annotation;

    public final XAnnotation annotation() {
        return this.annotation;
    }

    public abstract ClassName className();

    public final String simpleName() {
        return this.className().simpleName();
    }

    public final boolean isSubcomponent() {
        return SUBCOMPONENT_ANNOTATIONS.contains((Object)this.className());
    }

    public final boolean isProduction() {
        return PRODUCTION_ANNOTATIONS.contains((Object)this.className());
    }

    public final boolean isRealComponent() {
        return ALL_COMPONENT_ANNOTATIONS.contains((Object)this.className());
    }

    @Memoized
    public ImmutableList<XType> dependencyTypes() {
        return this.isRootComponent() ? ImmutableList.copyOf((Collection)this.annotation.getAsTypeList("dependencies")) : ImmutableList.of();
    }

    @Memoized
    public ImmutableSet<XTypeElement> dependencies() {
        return (ImmutableSet)this.dependencyTypes().stream().map(XType::getTypeElement).collect(DaggerStreams.toImmutableSet());
    }

    @Memoized
    public ImmutableSet<XTypeElement> modules() {
        return (ImmutableSet)this.annotation.getAsTypeList(this.isRealComponent() ? "modules" : "includes").stream().map(XType::getTypeElement).collect(DaggerStreams.toImmutableSet());
    }

    private final boolean isRootComponent() {
        return ROOT_COMPONENT_ANNOTATIONS.contains((Object)this.className());
    }

    public static Optional<ComponentAnnotation> rootComponentAnnotation(XTypeElement typeElement, DaggerSuperficialValidation superficialValidation) {
        return ComponentAnnotation.anyComponentAnnotation((XElement)typeElement, ROOT_COMPONENT_ANNOTATIONS, superficialValidation);
    }

    public static Optional<ComponentAnnotation> subcomponentAnnotation(XTypeElement typeElement, DaggerSuperficialValidation superficialValidation) {
        return ComponentAnnotation.anyComponentAnnotation((XElement)typeElement, SUBCOMPONENT_ANNOTATIONS, superficialValidation);
    }

    public static Optional<ComponentAnnotation> anyComponentAnnotation(XElement element, DaggerSuperficialValidation superficialValidation) {
        return ComponentAnnotation.anyComponentAnnotation(element, ALL_COMPONENT_ANNOTATIONS, superficialValidation);
    }

    private static Optional<ComponentAnnotation> anyComponentAnnotation(XElement element, Collection<ClassName> annotations, DaggerSuperficialValidation superficialValidation) {
        return XElements.getAnyAnnotation((XAnnotated)element, annotations).map(annotation -> {
            superficialValidation.validateAnnotationOf(element, (XAnnotation)annotation);
            return ComponentAnnotation.create(annotation);
        });
    }

    public static boolean isComponentAnnotation(XAnnotation annotation) {
        return ALL_COMPONENT_ANNOTATIONS.contains((Object)XAnnotations.getClassName(annotation));
    }

    public static ComponentAnnotation fromModuleAnnotation(ModuleAnnotation moduleAnnotation) {
        return ComponentAnnotation.create(moduleAnnotation.annotation());
    }

    private static ComponentAnnotation create(XAnnotation annotation) {
        AutoValue_ComponentAnnotation componentAnnotation = new AutoValue_ComponentAnnotation(XAnnotations.getClassName(annotation));
        componentAnnotation.annotation = annotation;
        return componentAnnotation;
    }

    public static ImmutableSet<ClassName> rootComponentAnnotations() {
        return ROOT_COMPONENT_ANNOTATIONS;
    }

    public static ImmutableSet<ClassName> subcomponentAnnotations() {
        return SUBCOMPONENT_ANNOTATIONS;
    }

    public static ImmutableSet<ClassName> allComponentAnnotations() {
        return ALL_COMPONENT_ANNOTATIONS;
    }

    public static ImmutableSet<ClassName> allComponentAndCreatorAnnotations() {
        return ALL_COMPONENT_AND_CREATOR_ANNOTATIONS;
    }
}

