/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import dagger.internal.codegen.binding.AutoValue_MembersInjectionBinding;
import dagger.internal.codegen.binding.AutoValue_MembersInjectionBinding_InjectionSite;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;
import java.util.stream.Collectors;

@AutoValue
public abstract class MembersInjectionBinding
extends Binding {
    static MembersInjectionBinding create(Key key, ImmutableSet<DependencyRequest> dependencies, Optional<MembersInjectionBinding> unresolved, ImmutableSortedSet<InjectionSite> injectionSites) {
        return new AutoValue_MembersInjectionBinding(key, dependencies, unresolved, injectionSites);
    }

    @Override
    public final Optional<XElement> bindingElement() {
        return Optional.of(this.membersInjectedType());
    }

    public final XTypeElement membersInjectedType() {
        return this.key().type().xprocessing().getTypeElement();
    }

    public abstract Optional<MembersInjectionBinding> unresolved();

    @Override
    public Optional<XTypeElement> contributingModule() {
        return Optional.empty();
    }

    public abstract ImmutableSortedSet<InjectionSite> injectionSites();

    @Override
    public BindingType bindingType() {
        return BindingType.MEMBERS_INJECTION;
    }

    @Override
    public BindingKind kind() {
        return BindingKind.MEMBERS_INJECTION;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    public boolean hasLocalInjectionSites() {
        return this.injectionSites().stream().map(InjectionSite::enclosingTypeElement).anyMatch(this.membersInjectedType()::equals);
    }

    @Override
    public boolean requiresModuleInstance() {
        return false;
    }

    @Memoized
    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @AutoValue
    public static abstract class InjectionSite {
        public abstract Kind kind();

        public abstract XElement element();

        public abstract XTypeElement enclosingTypeElement();

        public abstract ImmutableSet<DependencyRequest> dependencies();

        @Memoized
        public int indexAmongAtInjectMembersWithSameSimpleName() {
            return this.enclosingTypeElement().getEnclosedElements().stream().filter(InjectionAnnotations::hasInjectAnnotation).filter(element -> !XElements.isPrivate(element)).filter(element -> XElements.getSimpleName(element).equals(XElements.getSimpleName(this.element()))).collect(Collectors.toList()).indexOf(this.element());
        }

        public static InjectionSite field(XFieldElement field, DependencyRequest dependency) {
            return InjectionSite.create(Kind.FIELD, (XElement)field, (ImmutableSet<DependencyRequest>)ImmutableSet.of((Object)dependency));
        }

        public static InjectionSite method(XMethodElement method, Iterable<DependencyRequest> dependencies) {
            return InjectionSite.create(Kind.METHOD, (XElement)method, (ImmutableSet<DependencyRequest>)ImmutableSet.copyOf(dependencies));
        }

        private static InjectionSite create(Kind kind, XElement element, ImmutableSet<DependencyRequest> dependencies) {
            XTypeElement enclosingTypeElement = (XTypeElement)Preconditions.checkNotNull((Object)XElements.closestEnclosingTypeElement(element));
            return new AutoValue_MembersInjectionBinding_InjectionSite(kind, element, enclosingTypeElement, dependencies);
        }

        public static enum Kind {
            FIELD,
            METHOD;

        }
    }
}

