/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.javapoet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.squareup.javapoet.AnnotationSpec;
import java.util.Collection;

public final class AnnotationSpecs {
    public static AnnotationSpec suppressWarnings(Suppression first, Suppression ... rest) {
        return AnnotationSpecs.suppressWarnings((ImmutableSet<Suppression>)ImmutableSet.copyOf((Collection)Lists.asList((Object)((Object)first), (Object[])rest)));
    }

    public static AnnotationSpec suppressWarnings(ImmutableSet<Suppression> suppressions) {
        Preconditions.checkArgument((!suppressions.isEmpty() ? 1 : 0) != 0);
        AnnotationSpec.Builder builder = AnnotationSpec.builder(SuppressWarnings.class);
        suppressions.stream().flatMap(suppression -> ((Suppression)suppression).values.stream()).forEach(value -> builder.addMember("value", "$S", new Object[]{value}));
        return builder.build();
    }

    private AnnotationSpecs() {
    }

    public static enum Suppression {
        RAWTYPES("rawtypes"),
        UNCHECKED("unchecked"),
        FUTURE_RETURN_VALUE_IGNORED("FutureReturnValueIgnored"),
        KOTLIN_INTERNAL("KotlinInternal", "KotlinInternalInJava");

        private final ImmutableList<String> values;

        private Suppression(String ... values) {
            this.values = ImmutableList.copyOf((Object[])values);
        }
    }
}

