/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.processingstep.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.InjectValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import java.util.HashSet;
import javax.inject.Inject;

final class AssistedInjectProcessingStep
extends TypeCheckingProcessingStep<XConstructorElement> {
    private final XMessager messager;
    private final InjectValidator injectValidator;

    @Inject
    AssistedInjectProcessingStep(XMessager messager, InjectValidator injectValidator) {
        this.messager = messager;
        this.injectValidator = injectValidator;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.ASSISTED_INJECT);
    }

    @Override
    protected void process(XConstructorElement assistedInjectElement, ImmutableSet<ClassName> annotations) {
        if (this.injectValidator.validate(assistedInjectElement.getEnclosingElement()).isClean()) {
            new AssistedInjectValidator().validate(assistedInjectElement).printMessagesTo(this.messager);
        }
    }

    private final class AssistedInjectValidator {
        private AssistedInjectValidator() {
        }

        ValidationReport validate(XConstructorElement constructor) {
            ValidationReport.Builder report = ValidationReport.about((XElement)constructor);
            XType assistedInjectType = constructor.getEnclosingElement().getType();
            ImmutableList<AssistedInjectionAnnotations.AssistedParameter> assistedParameters = AssistedInjectionAnnotations.assistedInjectAssistedParameters(assistedInjectType);
            HashSet<AssistedInjectionAnnotations.AssistedParameter> uniqueAssistedParameters = new HashSet<AssistedInjectionAnnotations.AssistedParameter>();
            for (AssistedInjectionAnnotations.AssistedParameter assistedParameter : assistedParameters) {
                if (uniqueAssistedParameters.add(assistedParameter)) continue;
                report.addError(String.format("@AssistedInject constructor has duplicate @Assisted type: %s. Consider setting an identifier on the parameter by using @Assisted(\"identifier\") in both the factory and @AssistedInject constructor", assistedParameter), (XElement)assistedParameter.element());
            }
            return report.build();
        }
    }
}

