/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.BindingFactory;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DelegateDeclaration;
import dagger.internal.codegen.binding.ProductionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.processingstep.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ModuleValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.writing.InaccessibleMapKeyProxyGenerator;
import dagger.internal.codegen.writing.ModuleGenerator;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

final class ModuleProcessingStep
extends TypeCheckingProcessingStep<XTypeElement> {
    private final XMessager messager;
    private final ModuleValidator moduleValidator;
    private final BindingFactory bindingFactory;
    private final SourceFileGenerator<ProvisionBinding> factoryGenerator;
    private final SourceFileGenerator<ProductionBinding> producerFactoryGenerator;
    private final SourceFileGenerator<XTypeElement> moduleConstructorProxyGenerator;
    private final InaccessibleMapKeyProxyGenerator inaccessibleMapKeyProxyGenerator;
    private final DelegateDeclaration.Factory delegateDeclarationFactory;
    private final Set<XTypeElement> processedModuleElements = Sets.newLinkedHashSet();

    @Inject
    ModuleProcessingStep(XMessager messager, ModuleValidator moduleValidator, BindingFactory bindingFactory, SourceFileGenerator<ProvisionBinding> factoryGenerator, SourceFileGenerator<ProductionBinding> producerFactoryGenerator, @ModuleGenerator SourceFileGenerator<XTypeElement> moduleConstructorProxyGenerator, InaccessibleMapKeyProxyGenerator inaccessibleMapKeyProxyGenerator, DelegateDeclaration.Factory delegateDeclarationFactory) {
        this.messager = messager;
        this.moduleValidator = moduleValidator;
        this.bindingFactory = bindingFactory;
        this.factoryGenerator = factoryGenerator;
        this.producerFactoryGenerator = producerFactoryGenerator;
        this.moduleConstructorProxyGenerator = moduleConstructorProxyGenerator;
        this.inaccessibleMapKeyProxyGenerator = inaccessibleMapKeyProxyGenerator;
        this.delegateDeclarationFactory = delegateDeclarationFactory;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.MODULE, (Object)TypeNames.PRODUCER_MODULE);
    }

    @Override
    public ImmutableSet<XElement> process(XProcessingEnv env, Map<String, ? extends Set<? extends XElement>> elementsByAnnotation) {
        this.moduleValidator.addKnownModules((Collection)elementsByAnnotation.values().stream().flatMap(Collection::stream).map(XTypeElement.class::cast).collect(DaggerStreams.toImmutableSet()));
        return super.process(env, elementsByAnnotation);
    }

    @Override
    protected void process(XTypeElement module, ImmutableSet<ClassName> annotations) {
        if (this.processedModuleElements.contains(module)) {
            return;
        }
        if (module.isCompanionObject()) {
            return;
        }
        ValidationReport report = this.moduleValidator.validate(module);
        report.printMessagesTo(this.messager);
        if (report.isClean()) {
            this.generateForMethodsIn(module);
            ((Optional)module.getEnclosedTypeElements().stream().filter(XTypeElement::isCompanionObject).collect(DaggerCollectors.toOptional())).ifPresent(this::generateForMethodsIn);
        }
        this.processedModuleElements.add(module);
    }

    private void generateForMethodsIn(XTypeElement module) {
        for (XMethodElement method : module.getDeclaredMethods()) {
            if (method.hasAnnotation(TypeNames.PROVIDES)) {
                this.generate(this.factoryGenerator, this.bindingFactory.providesMethodBinding(method, module));
                continue;
            }
            if (method.hasAnnotation(TypeNames.PRODUCES)) {
                this.generate(this.producerFactoryGenerator, this.bindingFactory.producesMethodBinding(method, module));
                continue;
            }
            if (!method.hasAnnotation(TypeNames.BINDS)) continue;
            this.inaccessibleMapKeyProxyGenerator.generate(this.bindsMethodBinding(module, method), this.messager);
        }
        if (!module.isCompanionObject()) {
            this.moduleConstructorProxyGenerator.generate(module, this.messager);
        }
    }

    private <B extends ContributionBinding> void generate(SourceFileGenerator<B> generator, B binding) {
        generator.generate(binding, this.messager);
        this.inaccessibleMapKeyProxyGenerator.generate(binding, this.messager);
    }

    private ContributionBinding bindsMethodBinding(XTypeElement module, XMethodElement method) {
        return this.bindingFactory.unresolvedDelegateBinding(this.delegateDeclarationFactory.create(method, module));
    }
}

