/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.BindingRepresentation;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.DelegateRequestRepresentation;
import dagger.internal.codegen.writing.DirectInstanceBindingRepresentation;
import dagger.internal.codegen.writing.FrameworkInstanceBindingRepresentation;
import dagger.internal.codegen.writing.FrameworkInstanceKind;
import dagger.internal.codegen.writing.FrameworkInstanceSupplier;
import dagger.internal.codegen.writing.ProviderInstanceSupplier;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.writing.StaticFactoryInstanceSupplier;
import dagger.internal.codegen.writing.SwitchingProviderInstanceSupplier;

final class ProvisionBindingRepresentation
implements BindingRepresentation {
    private final BindingGraph graph;
    private final ComponentImplementation.CompilerMode compilerMode;
    private final ProvisionBinding binding;
    private final DirectInstanceBindingRepresentation directInstanceBindingRepresentation;
    private final FrameworkInstanceBindingRepresentation frameworkInstanceBindingRepresentation;

    @AssistedInject
    ProvisionBindingRepresentation(@Assisted ProvisionBinding binding, BindingGraph graph, ComponentImplementation componentImplementation, DirectInstanceBindingRepresentation.Factory directInstanceBindingRepresentationFactory, FrameworkInstanceBindingRepresentation.Factory frameworkInstanceBindingRepresentationFactory, SwitchingProviderInstanceSupplier.Factory switchingProviderInstanceSupplierFactory, ProviderInstanceSupplier.Factory providerInstanceSupplierFactory, StaticFactoryInstanceSupplier.Factory staticFactoryInstanceSupplierFactory, CompilerOptions compilerOptions) {
        this.binding = binding;
        this.graph = graph;
        this.compilerMode = componentImplementation.compilerMode();
        this.directInstanceBindingRepresentation = directInstanceBindingRepresentationFactory.create(binding);
        FrameworkInstanceSupplier frameworkInstanceSupplier = null;
        switch (FrameworkInstanceKind.from(binding, this.compilerMode)) {
            case SWITCHING_PROVIDER: {
                frameworkInstanceSupplier = switchingProviderInstanceSupplierFactory.create(binding);
                break;
            }
            case STATIC_FACTORY: {
                frameworkInstanceSupplier = staticFactoryInstanceSupplierFactory.create(binding);
                break;
            }
            case PROVIDER_FIELD: {
                frameworkInstanceSupplier = providerInstanceSupplierFactory.create(binding);
            }
        }
        this.frameworkInstanceBindingRepresentation = frameworkInstanceBindingRepresentationFactory.create(binding, frameworkInstanceSupplier);
    }

    @Override
    public RequestRepresentation getRequestRepresentation(BindingRequest request) {
        return this.usesDirectInstanceExpression(request.requestKind()) ? this.directInstanceBindingRepresentation.getRequestRepresentation(request) : this.frameworkInstanceBindingRepresentation.getRequestRepresentation(request);
    }

    private boolean usesDirectInstanceExpression(RequestKind requestKind) {
        if (requestKind != RequestKind.INSTANCE && requestKind != RequestKind.FUTURE) {
            return false;
        }
        if (this.compilerMode.isFastInit() && this.graph.topLevelBindingGraph().hasFrameworkRequest(this.binding)) {
            return false;
        }
        switch (this.binding.kind()) {
            case MEMBERS_INJECTOR: 
            case ASSISTED_FACTORY: {
                return false;
            }
            case ASSISTED_INJECTION: {
                throw new IllegalStateException("Assisted injection binding shouldn't be requested with an instance request.");
            }
        }
        return !ProvisionBindingRepresentation.needsCaching(this.binding, this.graph);
    }

    static boolean needsCaching(ProvisionBinding binding, BindingGraph graph) {
        if (!binding.scope().isPresent()) {
            return false;
        }
        if (binding.kind().equals((Object)BindingKind.DELEGATE)) {
            return DelegateRequestRepresentation.isBindsScopeStrongerThanDependencyScope(binding, graph);
        }
        return true;
    }

    @AssistedFactory
    static interface Factory {
        public ProvisionBindingRepresentation create(ProvisionBinding var1);
    }
}

