/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.Preconditions;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.Nullability;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.lang.model.element.Modifier;

final class InjectionMethods {
    InjectionMethods() {
    }

    private static MethodSpec methodProxy(XMethodElement method, String methodName, InstanceCastPolicy instanceCastPolicy, CheckNotNullPolicy checkNotNullPolicy) {
        CodeBlock instance;
        XTypeElement enclosingType = XElements.asTypeElement((XElement)method.getEnclosingElement());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).varargs(method.isVarArgs()).addTypeVariables((Iterable)method.getExecutableType().getTypeVariableNames());
        UniqueNameSet parameterNameSet = new UniqueNameSet();
        if (method.isStatic() || enclosingType.isCompanionObject()) {
            instance = CodeBlock.of((String)"$T", (Object[])new Object[]{TypeNames.rawTypeName(enclosingType.getType().getTypeName())});
        } else if (enclosingType.isKotlinObject()) {
            instance = CodeBlock.of((String)"$T.INSTANCE", (Object[])new Object[]{TypeNames.rawTypeName(enclosingType.getType().getTypeName())});
        } else {
            builder.addTypeVariables(XTypeElements.typeVariableNames(enclosingType));
            boolean useObject = instanceCastPolicy.useObjectType(enclosingType.getType());
            instance = InjectionMethods.copyInstance(builder, parameterNameSet, enclosingType.getType(), useObject);
        }
        CodeBlock arguments = InjectionMethods.copyParameters(builder, parameterNameSet, method.getParameters());
        CodeBlock invocation = checkNotNullPolicy.checkForNull(CodeBlock.of((String)"$L.$L($L)", (Object[])new Object[]{instance, method.getJvmName(), arguments}));
        InjectionMethods.copyThrows(builder, (XExecutableElement)method);
        if (XTypeKt.isVoid((XType)method.getReturnType())) {
            return builder.addStatement("$L", new Object[]{invocation}).build();
        }
        Nullability.of((XElement)method).nullableAnnotations().forEach(arg_0 -> ((MethodSpec.Builder)builder).addAnnotation(arg_0));
        return builder.returns(method.getReturnType().getTypeName()).addStatement("return $L", new Object[]{invocation}).build();
    }

    private static MethodSpec fieldProxy(XFieldElement field, String methodName, Optional<XAnnotation> qualifier) {
        XTypeElement enclosingType = XElements.asTypeElement((XElement)field.getEnclosingElement());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(AnnotationSpec.builder((ClassName)TypeNames.INJECTED_FIELD_SIGNATURE).addMember("value", "$S", new Object[]{SourceFiles.memberInjectedFieldSignatureForVariable(field)}).build()).addTypeVariables(XTypeElements.typeVariableNames(enclosingType));
        qualifier.map(XAnnotations::getAnnotationSpec).ifPresent(arg_0 -> ((MethodSpec.Builder)builder).addAnnotation(arg_0));
        boolean useObject = !Accessibility.isRawTypePubliclyAccessible(enclosingType.getType());
        UniqueNameSet parameterNameSet = new UniqueNameSet();
        CodeBlock instance = InjectionMethods.copyInstance(builder, parameterNameSet, enclosingType.getType(), useObject);
        CodeBlock argument = InjectionMethods.copyParameters(builder, parameterNameSet, (List<? extends XVariableElement>)ImmutableList.of((Object)field));
        return builder.addStatement("$L.$L = $L", new Object[]{instance, XElements.getSimpleName((XElement)field), argument}).build();
    }

    private static CodeBlock invokeMethod(MethodSpec methodSpec, ImmutableList<CodeBlock> parameters, ClassName enclosingClass, ClassName requestingClass) {
        com.google.common.base.Preconditions.checkArgument((methodSpec.parameters.size() == parameters.size() ? 1 : 0) != 0);
        CodeBlock parameterBlock = CodeBlocks.makeParametersCodeBlock(parameters);
        return enclosingClass.equals((Object)requestingClass) ? CodeBlock.of((String)"$L($L)", (Object[])new Object[]{methodSpec.name, parameterBlock}) : CodeBlock.of((String)"$T.$L($L)", (Object[])new Object[]{enclosingClass, methodSpec.name, parameterBlock});
    }

    private static void copyThrows(MethodSpec.Builder methodBuilder, XExecutableElement method) {
        method.getThrownTypes().stream().map(XType::getTypeName).forEach(arg_0 -> ((MethodSpec.Builder)methodBuilder).addException(arg_0));
    }

    private static CodeBlock copyParameters(MethodSpec.Builder methodBuilder, UniqueNameSet parameterNameSet, List<? extends XVariableElement> parameters) {
        return parameters.stream().map(parameter -> {
            String name = parameterNameSet.getUniqueName(XElementKt.isMethodParameter((XElement)parameter) ? XElements.asMethodParameter((XElement)parameter).getJvmName() : XElements.getSimpleName((XElement)parameter));
            boolean useObject = !Accessibility.isRawTypePubliclyAccessible(parameter.getType());
            return InjectionMethods.copyParameter(methodBuilder, parameter.getType(), name, useObject);
        }).collect(CodeBlocks.toParametersCodeBlock());
    }

    private static CodeBlock copyParameter(MethodSpec.Builder methodBuilder, XType type, String name, boolean useObject) {
        ClassName typeName = useObject ? TypeName.OBJECT : type.getTypeName();
        methodBuilder.addParameter(ParameterSpec.builder((TypeName)typeName, (String)name, (Modifier[])new Modifier[0]).build());
        return useObject ? CodeBlock.of((String)"($T) $L", (Object[])new Object[]{type.getTypeName(), name}) : CodeBlock.of((String)"$L", (Object[])new Object[]{name});
    }

    private static CodeBlock copyInstance(MethodSpec.Builder methodBuilder, UniqueNameSet parameterNameSet, XType type, boolean useObject) {
        CodeBlock instance = InjectionMethods.copyParameter(methodBuilder, type, parameterNameSet.getUniqueName("instance"), useObject);
        return useObject ? CodeBlock.of((String)"($L)", (Object[])new Object[]{instance}) : instance;
    }

    private static enum CheckNotNullPolicy {
        IGNORE,
        CHECK_FOR_NULL;


        CodeBlock checkForNull(CodeBlock maybeNull) {
            return this.equals((Object)IGNORE) ? maybeNull : CodeBlock.of((String)"$T.checkNotNullFromProvides($L)", (Object[])new Object[]{Preconditions.class, maybeNull});
        }

        static CheckNotNullPolicy get(ProvisionBinding binding, CompilerOptions compilerOptions) {
            return binding.shouldCheckForNull(compilerOptions) ? CHECK_FOR_NULL : IGNORE;
        }
    }

    private static enum InstanceCastPolicy {
        CAST_IF_NOT_PUBLIC,
        IGNORE;


        boolean useObjectType(XType instanceType) {
            return this == CAST_IF_NOT_PUBLIC && !Accessibility.isRawTypePubliclyAccessible(instanceType);
        }
    }

    static final class InjectionSiteMethod {
        InjectionSiteMethod() {
        }

        static MethodSpec create(MembersInjectionBinding.InjectionSite injectionSite) {
            String methodName = InjectionSiteMethod.methodName(injectionSite);
            switch (injectionSite.kind()) {
                case METHOD: {
                    return InjectionMethods.methodProxy(XElements.asMethod(injectionSite.element()), methodName, InstanceCastPolicy.CAST_IF_NOT_PUBLIC, CheckNotNullPolicy.IGNORE);
                }
                case FIELD: {
                    Optional<XAnnotation> qualifier = ((DependencyRequest)injectionSite.dependencies().stream().collect(DaggerCollectors.onlyElement())).key().qualifier().map(DaggerAnnotation::xprocessing);
                    return InjectionMethods.fieldProxy(XElements.asField(injectionSite.element()), methodName, qualifier);
                }
            }
            throw new AssertionError(injectionSite);
        }

        static CodeBlock invokeAll(ImmutableSet<MembersInjectionBinding.InjectionSite> injectionSites, ClassName generatedTypeName, CodeBlock instanceCodeBlock, XType instanceType, Function<DependencyRequest, CodeBlock> dependencyUsage) {
            return injectionSites.stream().map(injectionSite -> {
                XType injectSiteType = injectionSite.enclosingTypeElement().getType();
                CodeBlock maybeCastedInstance = instanceType.getTypeName().equals((Object)TypeName.OBJECT) && Accessibility.isRawTypeAccessible(injectSiteType, generatedTypeName.packageName()) ? CodeBlock.of((String)"($T) $L", (Object[])new Object[]{XTypes.erasedTypeName(injectSiteType), instanceCodeBlock}) : instanceCodeBlock;
                return CodeBlock.of((String)"$L;", (Object[])new Object[]{InjectionSiteMethod.invoke(injectionSite, generatedTypeName, maybeCastedInstance, dependencyUsage)});
            }).collect(CodeBlocks.toConcatenatedCodeBlock());
        }

        private static CodeBlock invoke(MembersInjectionBinding.InjectionSite injectionSite, ClassName generatedTypeName, CodeBlock instanceCodeBlock, Function<DependencyRequest, CodeBlock> dependencyUsage) {
            ImmutableList arguments = ImmutableList.builder().add((Object)instanceCodeBlock).addAll((Iterable)injectionSite.dependencies().stream().map(dependencyUsage).collect(DaggerStreams.toImmutableList())).build();
            ClassName enclosingClass = SourceFiles.membersInjectorNameForType(injectionSite.enclosingTypeElement());
            MethodSpec methodSpec = InjectionSiteMethod.create(injectionSite);
            return InjectionMethods.invokeMethod(methodSpec, (ImmutableList<CodeBlock>)arguments, enclosingClass, generatedTypeName);
        }

        private static String methodName(MembersInjectionBinding.InjectionSite injectionSite) {
            int index = injectionSite.indexAmongAtInjectMembersWithSameSimpleName();
            String indexString = index == 0 ? "" : String.valueOf(index + 1);
            return "inject" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, XElements.getSimpleName(injectionSite.element())) + indexString;
        }
    }

    static final class ProvisionMethod {
        private static final ImmutableSet<String> BANNED_PROXY_NAMES = ImmutableSet.of((Object)"get", (Object)"create");

        ProvisionMethod() {
        }

        static MethodSpec create(ProvisionBinding binding, CompilerOptions compilerOptions) {
            XExecutableElement executableElement = XElements.asExecutable(binding.bindingElement().get());
            if (XElementKt.isConstructor((XElement)executableElement)) {
                return ProvisionMethod.constructorProxy(XElements.asConstructor((XElement)executableElement));
            }
            if (XElementKt.isMethod((XElement)executableElement)) {
                XMethodElement method = XElements.asMethod((XElement)executableElement);
                String methodName = BANNED_PROXY_NAMES.contains((Object)XElements.getSimpleName((XElement)method)) ? "proxy" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, XElements.getSimpleName((XElement)method)) : XElements.getSimpleName((XElement)method);
                return InjectionMethods.methodProxy(method, methodName, InstanceCastPolicy.IGNORE, CheckNotNullPolicy.get(binding, compilerOptions));
            }
            throw new AssertionError(executableElement);
        }

        static CodeBlock invoke(ProvisionBinding binding, Function<DependencyRequest, CodeBlock> dependencyUsage, Function<XExecutableParameterElement, String> uniqueAssistedParameterName, ClassName requestingClass, Optional<CodeBlock> moduleReference, CompilerOptions compilerOptions) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            moduleReference.ifPresent(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
            ProvisionMethod.invokeArguments(binding, dependencyUsage, uniqueAssistedParameterName).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
            ClassName enclosingClass = SourceFiles.generatedClassNameForBinding(binding);
            MethodSpec methodSpec = ProvisionMethod.create(binding, compilerOptions);
            return InjectionMethods.invokeMethod(methodSpec, (ImmutableList<CodeBlock>)arguments.build(), enclosingClass, requestingClass);
        }

        static ImmutableList<CodeBlock> invokeArguments(ProvisionBinding binding, Function<DependencyRequest, CodeBlock> dependencyUsage, Function<XExecutableParameterElement, String> uniqueAssistedParameterName) {
            ImmutableMap dependencyRequestMap = (ImmutableMap)binding.provisionDependencies().stream().collect(DaggerStreams.toImmutableMap(request -> XElements.asMethodParameter(request.requestElement().get().xprocessing()), request -> request));
            ImmutableList.Builder arguments = ImmutableList.builder();
            XExecutableElement method = XElements.asExecutable(binding.bindingElement().get());
            for (XExecutableParameterElement parameter : method.getParameters()) {
                if (AssistedInjectionAnnotations.isAssistedParameter((XVariableElement)parameter)) {
                    arguments.add((Object)CodeBlock.of((String)"$L", (Object[])new Object[]{uniqueAssistedParameterName.apply(parameter)}));
                    continue;
                }
                if (dependencyRequestMap.containsKey((Object)parameter)) {
                    DependencyRequest request2 = (DependencyRequest)dependencyRequestMap.get((Object)parameter);
                    arguments.add((Object)dependencyUsage.apply(request2));
                    continue;
                }
                throw new AssertionError((Object)("Unexpected parameter: " + parameter));
            }
            return arguments.build();
        }

        private static MethodSpec constructorProxy(XConstructorElement constructor) {
            XTypeElement enclosingType = constructor.getEnclosingElement();
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"newInstance").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).varargs(constructor.isVarArgs()).returns(enclosingType.getType().getTypeName()).addTypeVariables(XTypeElements.typeVariableNames(enclosingType));
            InjectionMethods.copyThrows(builder, (XExecutableElement)constructor);
            CodeBlock arguments = InjectionMethods.copyParameters(builder, new UniqueNameSet(), constructor.getParameters());
            return builder.addStatement("return new $T($L)", new Object[]{enclosingType.getType().getTypeName(), arguments}).build();
        }

        static boolean requiresInjectionMethod(ProvisionBinding binding, CompilerOptions compilerOptions, ClassName requestingClass) {
            XExecutableElement executableElement = XElements.asExecutable(binding.bindingElement().get());
            return !binding.injectionSites().isEmpty() || binding.shouldCheckForNull(compilerOptions) || !Accessibility.isElementAccessibleFrom((XElement)executableElement, requestingClass.packageName()) || executableElement.getParameters().stream().map(XVariableElement::getType).anyMatch(type -> !Accessibility.isRawTypeAccessible(type, requestingClass.packageName()));
        }
    }
}

