/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMessager;
import java.util.Optional;
import javax.tools.Diagnostic;

public final class SourceFileGenerationException
extends Exception {
    private final XElement associatedElement;

    SourceFileGenerationException(Optional<ClassName> generatedClassName, Throwable cause, XElement associatedElement) {
        super(SourceFileGenerationException.createMessage(generatedClassName, cause.getMessage()), cause);
        this.associatedElement = (XElement)Preconditions.checkNotNull((Object)associatedElement);
    }

    private static String createMessage(Optional<ClassName> generatedClassName, String message) {
        return String.format("Could not generate %s: %s.", generatedClassName.isPresent() ? generatedClassName.get() : "unknown file", message);
    }

    public void printMessageTo(XMessager messager) {
        messager.printMessage(Diagnostic.Kind.ERROR, this.getMessage(), this.associatedElement);
    }
}

