/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import dagger.internal.codegen.base.ElementFormatter;
import dagger.internal.codegen.base.Formatter;
import dagger.internal.codegen.binding.DependencyRequestFormatter;
import dagger.internal.codegen.extension.DaggerGraphs;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.Binding;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.ComponentPath;
import dagger.internal.codegen.model.DaggerElement;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public final class DiagnosticMessageGenerator {
    private final BindingGraph graph;
    private final DependencyRequestFormatter dependencyRequestFormatter;
    private final ElementFormatter elementFormatter;
    private final java.util.function.Function<XTypeElement, Iterable<XTypeElement>> supertypes;
    private final Table<BindingGraph.MaybeBinding, BindingGraph.DependencyEdge, ImmutableList<BindingGraph.Node>> shortestPaths = HashBasedTable.create();
    private final Formatter<BindingGraph.DependencyEdge> entryPointFormatter = new Formatter<BindingGraph.DependencyEdge>(){

        @Override
        public String format(BindingGraph.DependencyEdge object) {
            XElement requestElement = object.dependencyRequest().requestElement().get().xprocessing();
            StringBuilder builder = new StringBuilder(ElementFormatter.elementToString(requestElement));
            ComponentPath componentPath = DiagnosticMessageGenerator.this.source(object).componentPath();
            if (!componentPath.atRoot() || !requestElement.getEnclosingElement().equals((Object)componentPath.rootComponent().xprocessing())) {
                builder.append(String.format(" [%s]", componentPath));
            }
            return builder.toString();
        }
    };

    private static <K, V> java.util.function.Function<K, V> memoize(java.util.function.Function<K, V> uncached) {
        Function uncachedAsBaseFunction = uncached::apply;
        LoadingCache cache = CacheBuilder.newBuilder().build(CacheLoader.from((Function)uncachedAsBaseFunction));
        java.util.function.Function<Object, Object> memoized = arg_0 -> ((LoadingCache)cache).apply(arg_0);
        return memoized;
    }

    private DiagnosticMessageGenerator(BindingGraph graph, DependencyRequestFormatter dependencyRequestFormatter, ElementFormatter elementFormatter) {
        this.graph = graph;
        this.dependencyRequestFormatter = dependencyRequestFormatter;
        this.elementFormatter = elementFormatter;
        this.supertypes = DiagnosticMessageGenerator.memoize(component -> Iterables.transform((Iterable)component.getType().getSuperTypes(), XType::getTypeElement));
    }

    public String getMessage(BindingGraph.MaybeBinding binding) {
        ImmutableSet<BindingGraph.DependencyEdge> entryPoints = this.graph.entryPointEdgesDependingOnBinding(binding);
        ImmutableSet<BindingGraph.DependencyEdge> requests = this.requests(binding);
        ImmutableList<BindingGraph.DependencyEdge> dependencyTrace = this.dependencyTrace(binding, entryPoints);
        return this.getMessageInternal(dependencyTrace, requests, entryPoints);
    }

    public String getMessage(BindingGraph.DependencyEdge dependencyEdge) {
        ImmutableList dependencyTrace;
        ImmutableSet<BindingGraph.DependencyEdge> entryPoints;
        ImmutableSet requests = ImmutableSet.of((Object)dependencyEdge);
        if (dependencyEdge.isEntryPoint()) {
            entryPoints = ImmutableSet.of((Object)dependencyEdge);
            dependencyTrace = ImmutableList.of((Object)dependencyEdge);
        } else {
            Binding binding = (Binding)this.source(dependencyEdge);
            entryPoints = this.graph.entryPointEdgesDependingOnBinding(binding);
            dependencyTrace = ImmutableList.builder().add((Object)dependencyEdge).addAll(this.dependencyTrace(binding, entryPoints)).build();
        }
        return this.getMessageInternal((ImmutableList<BindingGraph.DependencyEdge>)dependencyTrace, (ImmutableSet<BindingGraph.DependencyEdge>)requests, entryPoints);
    }

    private String getMessageInternal(ImmutableList<BindingGraph.DependencyEdge> dependencyTrace, ImmutableSet<BindingGraph.DependencyEdge> requests, ImmutableSet<BindingGraph.DependencyEdge> entryPoints) {
        StringBuilder message = new StringBuilder(dependencyTrace.size() * 100);
        dependencyTrace.forEach(edge -> this.dependencyRequestFormatter.appendFormatLine(message, edge.dependencyRequest()));
        if (!dependencyTrace.isEmpty()) {
            this.appendComponentPathUnlessAtRoot(message, this.source((BindingGraph.Edge)Iterables.getLast(dependencyTrace)));
        }
        message.append(this.getRequestsNotInTrace(dependencyTrace, requests, entryPoints));
        return message.toString();
    }

    public String getRequestsNotInTrace(ImmutableList<BindingGraph.DependencyEdge> dependencyTrace, ImmutableSet<BindingGraph.DependencyEdge> requests, ImmutableSet<BindingGraph.DependencyEdge> entryPoints) {
        StringBuilder message = new StringBuilder();
        ImmutableSet requestsToPrint = (ImmutableSet)requests.stream().filter(request -> !request.isEntryPoint()).filter(request -> !this.isTracedRequest(dependencyTrace, (BindingGraph.DependencyEdge)request)).map(request -> request.dependencyRequest().requestElement()).flatMap(DaggerStreams.presentValues()).map(DaggerElement::xprocessing).collect(DaggerStreams.toImmutableSet());
        if (!requestsToPrint.isEmpty()) {
            message.append("\nIt is also requested at:");
            this.elementFormatter.formatIndentedList(message, requestsToPrint, 1);
        }
        if (entryPoints.size() > 1) {
            message.append("\nThe following other entry points also depend on it:");
            this.entryPointFormatter.formatIndentedList(message, (Iterable)entryPoints.stream().filter(entryPoint -> !entryPoint.equals(Iterables.getLast((Iterable)dependencyTrace))).sorted(this.rootComponentFirst().thenComparing(this.nearestComponentSupertypeFirst()).thenComparing(this.requestElementDeclarationOrder())).collect(DaggerStreams.toImmutableList()), 1);
        }
        return message.toString();
    }

    public void appendComponentPathUnlessAtRoot(StringBuilder message, BindingGraph.Node node) {
        if (!node.componentPath().equals(this.graph.rootComponentNode().componentPath())) {
            message.append(String.format(" [%s]", node.componentPath()));
        }
    }

    private boolean isTracedRequest(ImmutableList<BindingGraph.DependencyEdge> dependencyTrace, BindingGraph.DependencyEdge request) {
        return !dependencyTrace.isEmpty() && request.dependencyRequest().equals(((BindingGraph.DependencyEdge)dependencyTrace.get(0)).dependencyRequest()) && ((BindingGraph.Node)this.graph.network().incidentNodes((Object)request).target()).equals(this.graph.network().incidentNodes((Object)((BindingGraph.Edge)dependencyTrace.get(0))).target());
    }

    public ImmutableList<BindingGraph.DependencyEdge> dependencyTrace(BindingGraph.MaybeBinding binding, ImmutableSet<BindingGraph.DependencyEdge> entryPoints) {
        if (entryPoints.isEmpty()) {
            return ImmutableList.of();
        }
        BindingGraph.DependencyEdge entryPointForTrace = Collections.min(entryPoints, this.rootComponentFirst().thenComparing(this.shortestDependencyPathFirst(binding)).thenComparing(this.nearestComponentSupertypeFirst()).thenComparing(this.requestElementDeclarationOrder()));
        ImmutableList<BindingGraph.Node> shortestBindingPath = this.shortestPathFromEntryPoint(entryPointForTrace, binding);
        Verify.verify((!shortestBindingPath.isEmpty() ? 1 : 0) != 0, (String)"no dependency path from %s to %s in %s", (Object)entryPointForTrace, (Object)binding, (Object)this.graph);
        ImmutableList.Builder dependencyTrace = ImmutableList.builder();
        dependencyTrace.add((Object)entryPointForTrace);
        for (int i = 0; i < shortestBindingPath.size() - 1; ++i) {
            Set dependenciesBetween = this.graph.network().edgesConnecting((Object)((BindingGraph.Node)shortestBindingPath.get(i)), (Object)((BindingGraph.Node)shortestBindingPath.get(i + 1)));
            dependencyTrace.add((Object)((BindingGraph.DependencyEdge)Iterables.get((Iterable)dependenciesBetween, (int)0)));
        }
        return dependencyTrace.build().reverse();
    }

    public ImmutableSet<BindingGraph.DependencyEdge> requests(BindingGraph.MaybeBinding binding) {
        return (ImmutableSet)this.graph.network().inEdges((Object)binding).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.DependencyEdge.class)).filter(edge -> edge.dependencyRequest().requestElement().isPresent()).sorted(this.requestEnclosingTypeName().thenComparing(this.requestElementDeclarationOrder())).collect(DaggerStreams.toImmutableSet());
    }

    private Comparator<BindingGraph.DependencyEdge> rootComponentFirst() {
        return Comparator.comparingInt(entryPoint -> this.source((BindingGraph.Edge)entryPoint).componentPath().components().size());
    }

    private Comparator<BindingGraph.DependencyEdge> shortestDependencyPathFirst(BindingGraph.MaybeBinding binding) {
        return Comparator.comparing(entryPoint -> this.shortestPathFromEntryPoint((BindingGraph.DependencyEdge)entryPoint, binding).size());
    }

    private ImmutableList<BindingGraph.Node> shortestPathFromEntryPoint(BindingGraph.DependencyEdge entryPoint, BindingGraph.MaybeBinding binding) {
        return this.shortestPaths.row((Object)binding).computeIfAbsent(entryPoint, ep -> DaggerGraphs.shortestPath(node -> Iterables.filter((Iterable)this.graph.network().successors(node), BindingGraph.MaybeBinding.class::isInstance), (Object)((BindingGraph.Node)this.graph.network().incidentNodes(ep).target()), (Object)binding));
    }

    private Comparator<BindingGraph.DependencyEdge> nearestComponentSupertypeFirst() {
        return Comparator.comparingInt(entryPoint -> Iterables.indexOf(this.supertypes.apply(this.componentContainingEntryPoint((BindingGraph.DependencyEdge)entryPoint)), (Predicate)Predicates.equalTo((Object)this.typeDeclaringEntryPoint((BindingGraph.DependencyEdge)entryPoint))));
    }

    private XTypeElement componentContainingEntryPoint(BindingGraph.DependencyEdge entryPoint) {
        return this.source(entryPoint).componentPath().currentComponent().xprocessing();
    }

    private XTypeElement typeDeclaringEntryPoint(BindingGraph.DependencyEdge entryPoint) {
        return XElements.asTypeElement(entryPoint.dependencyRequest().requestElement().get().xprocessing().getEnclosingElement());
    }

    private Comparator<BindingGraph.DependencyEdge> requestEnclosingTypeName() {
        return Comparator.comparing(edge -> XElements.closestEnclosingTypeElement(edge.dependencyRequest().requestElement().get().xprocessing()).getQualifiedName());
    }

    private Comparator<BindingGraph.DependencyEdge> requestElementDeclarationOrder() {
        return Comparator.comparing(edge -> edge.dependencyRequest().requestElement().get().xprocessing(), Comparator.comparing(element -> {
            XElement enclosingElement = element.getEnclosingElement();
            Preconditions.checkState((XElementKt.isTypeElement((XElement)enclosingElement) || XElements.isExecutable(enclosingElement) ? 1 : 0) != 0);
            List siblings = XElementKt.isTypeElement((XElement)enclosingElement) ? XElements.asTypeElement(enclosingElement).getEnclosedElements() : XElements.asExecutable(enclosingElement).getParameters();
            return siblings.indexOf(element);
        }));
    }

    private BindingGraph.Node source(BindingGraph.Edge edge) {
        return (BindingGraph.Node)this.graph.network().incidentNodes((Object)edge).source();
    }

    public static final class Factory {
        private final DependencyRequestFormatter dependencyRequestFormatter;
        private final ElementFormatter elementFormatter;

        @Inject
        Factory(DependencyRequestFormatter dependencyRequestFormatter, ElementFormatter elementFormatter) {
            this.dependencyRequestFormatter = dependencyRequestFormatter;
            this.elementFormatter = elementFormatter;
        }

        public DiagnosticMessageGenerator create(BindingGraph graph) {
            return new DiagnosticMessageGenerator(graph, this.dependencyRequestFormatter, this.elementFormatter);
        }
    }
}

