/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XHasModifiers;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeParameterElement;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;

public final class XTypeElements {
    public static ImmutableList<XTypeName> typeVariableNames(XTypeElement typeElement) {
        return (ImmutableList)typeElement.getTypeParameters().stream().map(XTypeParameterElement::asTypeVariableName).collect(DaggerStreams.toImmutableList());
    }

    public static boolean isNested(XTypeElement typeElement) {
        return typeElement.getEnclosingTypeElement() != null;
    }

    public static boolean hasTypeParameters(XTypeElement typeElement) {
        return !typeElement.getTypeParameters().isEmpty();
    }

    public static ImmutableList<XMethodElement> getAllUnimplementedMethods(XTypeElement type) {
        return (ImmutableList)XTypeElements.getAllNonPrivateInstanceMethods(type).stream().filter(XHasModifiers::isAbstract).collect(DaggerStreams.toImmutableList());
    }

    public static ImmutableList<XMethodElement> getAllNonPrivateInstanceMethods(XTypeElement type) {
        return (ImmutableList)XTypeElements.getAllMethods(type).stream().filter(method -> !method.isPrivate() && !method.isStatic()).collect(DaggerStreams.toImmutableList());
    }

    public static ImmutableList<XMethodElement> getAllMethods(XTypeElement type) {
        return (ImmutableList)StreamsKt.asStream((Sequence)type.getAllMethods()).filter(method -> XTypeElements.isAccessibleFrom(method, type)).collect(DaggerStreams.toImmutableList());
    }

    public static ImmutableList<XMethodElement> getAllMethodsIncludingPrivate(XTypeElement type) {
        return (ImmutableList)StreamsKt.asStream((Sequence)type.getAllMethods()).collect(DaggerStreams.toImmutableList());
    }

    private static boolean isAccessibleFrom(XMethodElement method, XTypeElement type) {
        if (method.isPublic() || method.isProtected()) {
            return true;
        }
        if (method.isPrivate()) {
            return false;
        }
        return method.getClosestMemberContainer().getClassName().packageName().equals(type.getClassName().packageName());
    }

    public static boolean isEffectivelyPublic(XTypeElement element) {
        return XTypeElements.allVisibilities(element).stream().allMatch(visibility -> visibility.equals((Object)Visibility.PUBLIC));
    }

    public static boolean isEffectivelyPrivate(XTypeElement element) {
        return XTypeElements.allVisibilities(element).contains((Object)Visibility.PRIVATE);
    }

    public static boolean isJvmClass(XTypeElement element) {
        return element.isClass() || element.isKotlinObject() || element.isCompanionObject();
    }

    private static ImmutableSet<Visibility> allVisibilities(XTypeElement element) {
        Preconditions.checkNotNull((Object)element);
        ImmutableSet.Builder visibilities = ImmutableSet.builder();
        for (XTypeElement currentElement = element; currentElement != null; currentElement = currentElement.getEnclosingTypeElement()) {
            visibilities.add((Object)Visibility.of(currentElement));
        }
        return visibilities.build();
    }

    private XTypeElements() {
    }

    private static enum Visibility {
        PUBLIC,
        PRIVATE,
        OTHER;


        private static Visibility of(XTypeElement element) {
            Preconditions.checkNotNull((Object)element);
            if (element.isPrivate()) {
                return PRIVATE;
            }
            if (element.isPublic()) {
                return PUBLIC;
            }
            return OTHER;
        }
    }
}

