/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import dagger.internal.codegen.binding.$AutoValue_MembersInjectionBinding;
import dagger.internal.codegen.binding.AutoValue_MembersInjectionBinding_InjectionSite;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.function.Predicate;

@AutoValue
public abstract class MembersInjectionBinding
extends Binding {
    @Override
    public final Optional<XElement> bindingElement() {
        return Optional.of(this.membersInjectedType());
    }

    public final XTypeElement membersInjectedType() {
        return this.key().type().xprocessing().getTypeElement();
    }

    @Override
    public Optional<XTypeElement> contributingModule() {
        return Optional.empty();
    }

    public abstract ImmutableSortedSet<InjectionSite> injectionSites();

    @Override
    public Optional<BindingType> optionalBindingType() {
        return Optional.of(BindingType.MEMBERS_INJECTION);
    }

    @Override
    public BindingKind kind() {
        return BindingKind.MEMBERS_INJECTION;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public final ImmutableSet<DependencyRequest> dependencies() {
        return (ImmutableSet)this.injectionSites().stream().flatMap(injectionSite -> injectionSite.dependencies().stream()).collect(DaggerStreams.toImmutableSet());
    }

    public boolean hasLocalInjectionSites() {
        return this.injectionSites().stream().map(InjectionSite::enclosingTypeElement).anyMatch((Predicate<XTypeElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ldagger/spi/internal/shaded/androidx/room/compiler/processing/XTypeElement;)Z)((XTypeElement)this.membersInjectedType()));
    }

    @Override
    public boolean requiresModuleInstance() {
        return false;
    }

    @Override
    public Optional<Scope> scope() {
        return Optional.empty();
    }

    @Memoized
    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    static Builder builder() {
        return new $AutoValue_MembersInjectionBinding.Builder();
    }

    @AutoValue
    public static abstract class InjectionSite {
        public abstract Kind kind();

        public abstract XElement element();

        public abstract XTypeElement enclosingTypeElement();

        public abstract ImmutableSet<DependencyRequest> dependencies();

        @Memoized
        public int indexAmongAtInjectMembersWithSameSimpleName() {
            return ((ImmutableList)this.enclosingTypeElement().getEnclosedElements().stream().filter(InjectionAnnotations::hasInjectAnnotation).filter(element -> !XElements.isPrivate(element)).filter(element -> XElements.getSimpleName(element).equals(XElements.getSimpleName(this.element()))).collect(DaggerStreams.toImmutableList())).indexOf((Object)this.element());
        }

        public static InjectionSite field(XFieldElement field, DependencyRequest dependency) {
            return InjectionSite.create(Kind.FIELD, field, (ImmutableSet<DependencyRequest>)ImmutableSet.of((Object)dependency));
        }

        public static InjectionSite method(XMethodElement method, Iterable<DependencyRequest> dependencies) {
            return InjectionSite.create(Kind.METHOD, method, (ImmutableSet<DependencyRequest>)ImmutableSet.copyOf(dependencies));
        }

        private static InjectionSite create(Kind kind, XElement element, ImmutableSet<DependencyRequest> dependencies) {
            XTypeElement enclosingTypeElement = (XTypeElement)Preconditions.checkNotNull((Object)XElements.closestEnclosingTypeElement(element));
            return new AutoValue_MembersInjectionBinding_InjectionSite(kind, element, enclosingTypeElement, dependencies);
        }

        public static enum Kind {
            FIELD,
            METHOD;

        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder key(Key var1);

        abstract Builder unresolved(Optional<? extends Binding> var1);

        abstract Builder injectionSites(ImmutableSortedSet<InjectionSite> var1);

        abstract MembersInjectionBinding build();
    }
}

