/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.plugin;

import com.android.build.gradle.api.UnitTestVariant;
import dagger.hilt.android.plugin.AndroidEntryPointClassTransformer;
import dagger.hilt.android.plugin.HiltExtension;
import dagger.hilt.android.plugin.HiltTransformTestClassesTask;
import dagger.hilt.android.plugin.util.FilesKt;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u000f2\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0007R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldagger/hilt/android/plugin/HiltTransformTestClassesTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "compiledClasses", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getCompiledClasses", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "transformClasses", "", "Companion", "ConfigAction", "Parameters", "WorkerAction", "plugin"})
public abstract class HiltTransformTestClassesTask
extends DefaultTask {
    private final WorkerExecutor workerExecutor;
    private static final String TASK_PREFIX = "hiltTransformFor";
    public static final Companion Companion = new Companion(null);

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getCompiledClasses();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @TaskAction
    public final void transformClasses() {
        this.workerExecutor.noIsolation().submit(WorkerAction.class, (Action)new Action<Parameters>(this){
            final /* synthetic */ HiltTransformTestClassesTask this$0;

            public final void execute(Parameters it) {
                it.getCompiledClasses().from(new Object[]{this.this$0.getCompiledClasses()});
                it.getOutputDir().set((Provider)this.this$0.getOutputDir());
                it.getName().set((Object)this.this$0.getName());
            }
            {
                this.this$0 = hiltTransformTestClassesTask;
            }
        });
    }

    @Inject
    public HiltTransformTestClassesTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Ldagger/hilt/android/plugin/HiltTransformTestClassesTask$Parameters;", "Lorg/gradle/workers/WorkParameters;", "compiledClasses", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getCompiledClasses", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "name", "Lorg/gradle/api/provider/Property;", "", "getName", "()Lorg/gradle/api/provider/Property;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "plugin"})
    public static interface Parameters
    extends WorkParameters {
        @NotNull
        public Property<String> getName();

        @NotNull
        public ConfigurableFileCollection getCompiledClasses();

        @NotNull
        public DirectoryProperty getOutputDir();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Ldagger/hilt/android/plugin/HiltTransformTestClassesTask$WorkerAction;", "Lorg/gradle/workers/WorkAction;", "Ldagger/hilt/android/plugin/HiltTransformTestClassesTask$Parameters;", "()V", "execute", "", "plugin"})
    public static abstract class WorkerAction
    implements WorkAction<Parameters> {
        public void execute() {
            File outputDir;
            File file = outputDir = (File)((Parameters)this.getParameters()).getOutputDir().getAsFile().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDir");
            kotlin.io.FilesKt.deleteRecursively((File)file);
            outputDir.mkdirs();
            Set set = ((Parameters)this.getParameters()).getCompiledClasses().getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"parameters.compiledClasses.files");
            List allInputs = CollectionsKt.toList((Iterable)set);
            Object object = ((Parameters)this.getParameters()).getName().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.name.get()");
            AndroidEntryPointClassTransformer classTransformer = new AndroidEntryPointClassTransformer((String)object, allInputs, outputDir, false);
            Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)allInputs);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                File file2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                if (file2.isDirectory()) {
                    Sequence $this$forEach$iv2 = (Sequence)kotlin.io.FilesKt.walkTopDown((File)it);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        File file3 = (File)element$iv2;
                        boolean bl2 = false;
                        if (!FilesKt.isClassFile(file3)) continue;
                        classTransformer.transformFile(file3);
                    }
                    continue;
                }
                if (!FilesKt.isJarFile(it)) continue;
                classTransformer.transformJarContents(it);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldagger/hilt/android/plugin/HiltTransformTestClassesTask$ConfigAction;", "Lorg/gradle/api/Action;", "Ldagger/hilt/android/plugin/HiltTransformTestClassesTask;", "outputDir", "Ljava/io/File;", "inputClasspath", "Lorg/gradle/api/file/FileCollection;", "(Ljava/io/File;Lorg/gradle/api/file/FileCollection;)V", "execute", "", "transformTask", "plugin"})
    public static final class ConfigAction
    implements Action<HiltTransformTestClassesTask> {
        private final File outputDir;
        private final FileCollection inputClasspath;

        public void execute(@NotNull HiltTransformTestClassesTask transformTask) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)transformTask), (String)"transformTask");
            transformTask.setDescription("Transforms AndroidEntryPoint annotated classes for JUnit tests.");
            transformTask.getOutputDir().set(this.outputDir);
            transformTask.getCompiledClasses().from(new Object[]{this.inputClasspath});
        }

        public ConfigAction(@NotNull File outputDir, @NotNull FileCollection inputClasspath) {
            Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
            Intrinsics.checkParameterIsNotNull((Object)inputClasspath, (String)"inputClasspath");
            this.outputDir = outputDir;
            this.inputClasspath = inputClasspath;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldagger/hilt/android/plugin/HiltTransformTestClassesTask$Companion;", "", "()V", "TASK_PREFIX", "", "create", "", "project", "Lorg/gradle/api/Project;", "unitTestVariant", "Lcom/android/build/gradle/api/UnitTestVariant;", "extension", "Ldagger/hilt/android/plugin/HiltExtension;", "plugin"})
    public static final class Companion {
        public final void create(@NotNull Project project, @NotNull UnitTestVariant unitTestVariant, @NotNull HiltExtension extension) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)unitTestVariant, (String)"unitTestVariant");
            Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
            if (!extension.getEnableTransformForLocalTests()) {
                return;
            }
            ConfigurableFileCollection inputClasspath = project.getObjects().fileCollection().from(new Object[]{unitTestVariant.getCompileClasspath(null)});
            TaskContainer taskContainer = project.getTasks();
            StringBuilder stringBuilder = new StringBuilder().append("compile");
            String string = unitTestVariant.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"unitTestVariant.name");
            TaskProvider taskProvider = taskContainer.named(stringBuilder.append(StringsKt.capitalize((String)string)).append("JavaWithJavac").toString());
            if (taskProvider == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.tasks.TaskProvider<org.gradle.api.tasks.compile.JavaCompile>");
            }
            TaskProvider testCompileTaskProvider = taskProvider;
            inputClasspath.from(new Object[]{testCompileTaskProvider.map((Transformer)create.1.INSTANCE)});
            project.getPlugins().withType(KotlinBasePluginWrapper.class, (Action)new Action<KotlinBasePluginWrapper>(project, unitTestVariant, inputClasspath){
                final /* synthetic */ Project $project;
                final /* synthetic */ UnitTestVariant $unitTestVariant;
                final /* synthetic */ ConfigurableFileCollection $inputClasspath;

                public final void execute(KotlinBasePluginWrapper it) {
                    TaskContainer taskContainer = this.$project.getTasks();
                    StringBuilder stringBuilder = new StringBuilder().append("compile");
                    String string = this.$unitTestVariant.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"unitTestVariant.name");
                    TaskProvider taskProvider = taskContainer.named(stringBuilder.append(StringsKt.capitalize((String)string)).append("Kotlin").toString());
                    if (taskProvider == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.tasks.TaskProvider<org.jetbrains.kotlin.gradle.tasks.KotlinCompile>");
                    }
                    TaskProvider kotlinCompileTaskProvider = taskProvider;
                    this.$inputClasspath.from(new Object[]{kotlinCompileTaskProvider.map((Transformer)Companion.create.1.INSTANCE)});
                }
                {
                    this.$project = project;
                    this.$unitTestVariant = unitTestVariant;
                    this.$inputClasspath = configurableFileCollection;
                }
            });
            File file = project.getBuildDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildDir");
            File outputDir = kotlin.io.FilesKt.resolve((File)file, (String)("intermediates/hilt/" + unitTestVariant.getDirName() + "Output"));
            TaskContainer taskContainer2 = project.getTasks();
            StringBuilder stringBuilder2 = new StringBuilder().append(HiltTransformTestClassesTask.TASK_PREFIX);
            String string2 = unitTestVariant.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"unitTestVariant.name");
            String string3 = stringBuilder2.append(StringsKt.capitalize((String)string2)).toString();
            ConfigurableFileCollection configurableFileCollection = inputClasspath;
            Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"inputClasspath");
            TaskProvider hiltTransformProvider = taskContainer2.register(string3, HiltTransformTestClassesTask.class, (Action)new ConfigAction(outputDir, (FileCollection)configurableFileCollection));
            ConfigurableFileCollection outputFileCollection2 = project.getObjects().fileCollection().from(new Object[]{hiltTransformProvider.map((Transformer)create.outputFileCollection.1.INSTANCE)});
            TaskContainer taskContainer3 = project.getTasks();
            StringBuilder stringBuilder3 = new StringBuilder().append("test");
            String string4 = unitTestVariant.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"unitTestVariant.name");
            TaskProvider taskProvider2 = taskContainer3.named(stringBuilder3.append(StringsKt.capitalize((String)string4)).toString());
            if (taskProvider2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.tasks.TaskProvider<org.gradle.api.tasks.testing.Test>");
            }
            TaskProvider testTaskProvider = taskProvider2;
            testTaskProvider.configure((Action)new Action<Test>(outputFileCollection2){
                final /* synthetic */ ConfigurableFileCollection $outputFileCollection;

                public final void execute(Test it) {
                    Test test = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)test, (String)"it");
                    test.setClasspath(this.$outputFileCollection.plus(it.getClasspath()));
                }
                {
                    this.$outputFileCollection = configurableFileCollection;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

