/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import dagger.hilt.android.shaded.auto.common.MoreElements;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;

public final class ElementDescriptors {
    private static final SimpleTypeVisitor8<String, Void> JVM_DESCRIPTOR_TYPE_VISITOR = new SimpleTypeVisitor8<String, Void>(){

        @Override
        public String visitArray(ArrayType arrayType, Void v) {
            return "[" + ElementDescriptors.getDescriptor(arrayType.getComponentType());
        }

        @Override
        public String visitDeclared(DeclaredType declaredType, Void v) {
            return "L" + this.getInternalName(declaredType.asElement()) + ";";
        }

        @Override
        public String visitError(ErrorType errorType, Void v) {
            return this.visitDeclared((DeclaredType)errorType, v);
        }

        @Override
        public String visitExecutable(ExecutableType executableType, Void v) {
            String parameterDescriptors = executableType.getParameterTypes().stream().map(x$0 -> ElementDescriptors.getDescriptor(x$0)).collect(Collectors.joining());
            String returnDescriptor = ElementDescriptors.getDescriptor(executableType.getReturnType());
            return "(" + parameterDescriptors + ")" + returnDescriptor;
        }

        @Override
        public String visitIntersection(IntersectionType intersectionType, Void v) {
            return ElementDescriptors.getDescriptor(intersectionType.getBounds().get(0));
        }

        @Override
        public String visitNoType(NoType noType, Void v) {
            return "V";
        }

        @Override
        public String visitPrimitive(PrimitiveType primitiveType, Void v) {
            switch (primitiveType.getKind()) {
                case BOOLEAN: {
                    return "Z";
                }
                case BYTE: {
                    return "B";
                }
                case SHORT: {
                    return "S";
                }
                case INT: {
                    return "I";
                }
                case LONG: {
                    return "J";
                }
                case CHAR: {
                    return "C";
                }
                case FLOAT: {
                    return "F";
                }
                case DOUBLE: {
                    return "D";
                }
            }
            throw new IllegalArgumentException("Unknown primitive type.");
        }

        @Override
        public String visitTypeVariable(TypeVariable typeVariable, Void v) {
            return ElementDescriptors.getDescriptor(typeVariable.getUpperBound());
        }

        @Override
        public String defaultAction(TypeMirror typeMirror, Void v) {
            throw new IllegalArgumentException("Unsupported type: " + typeMirror);
        }

        @Override
        public String visitWildcard(WildcardType wildcardType, Void v) {
            return "";
        }

        private String getInternalName(Element element) {
            if (MoreElements.isType(element)) {
                TypeElement typeElement = MoreElements.asType(element);
                switch (typeElement.getNestingKind()) {
                    case TOP_LEVEL: {
                        return typeElement.getQualifiedName().toString().replace('.', '/');
                    }
                    case MEMBER: {
                        return this.getInternalName(typeElement.getEnclosingElement()) + "$" + typeElement.getSimpleName();
                    }
                }
                throw new IllegalArgumentException("Unsupported nesting kind.");
            }
            return element.getSimpleName().toString();
        }
    };

    private ElementDescriptors() {
    }

    public static String getFieldDescriptor(VariableElement element) {
        return element.getSimpleName() + ":" + ElementDescriptors.getDescriptor(element.asType());
    }

    public static String getMethodDescriptor(ExecutableElement element) {
        return element.getSimpleName() + ElementDescriptors.getDescriptor(element.asType());
    }

    private static String getDescriptor(TypeMirror t) {
        return t.accept(JVM_DESCRIPTOR_TYPE_VISITOR, null);
    }
}

