/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aliasof;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.aliasof.AliasOfPropagatedDataMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import javax.lang.model.element.TypeElement;

public final class AliasOfs {
    private final ImmutableSetMultimap<ClassName, ClassName> defineComponentScopeToAliases;

    public static AliasOfs create(ImmutableSet<AliasOfPropagatedDataMetadata> metadatas, ImmutableSet<ComponentDescriptor> componentDescriptors) {
        ImmutableSet defineComponentScopes = (ImmutableSet)componentDescriptors.stream().flatMap(descriptor -> descriptor.scopes().stream()).collect(DaggerStreams.toImmutableSet());
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        metadatas.forEach(metadata -> {
            ClassName aliasScopeName = ClassName.get((TypeElement)metadata.aliasElement());
            metadata.defineComponentScopeElements().forEach(defineComponentScope -> {
                ClassName defineComponentScopeName = ClassName.get((TypeElement)defineComponentScope);
                ProcessorErrors.checkState(defineComponentScopes.contains((Object)defineComponentScopeName), metadata.aliasElement(), "The scope %s cannot be an alias for %s. You can only have aliases of a scope defined directly on a @DefineComponent type.", aliasScopeName, defineComponentScopeName);
                builder.put((Object)defineComponentScopeName, (Object)aliasScopeName);
            });
        });
        return new AliasOfs((ImmutableSetMultimap<ClassName, ClassName>)builder.build());
    }

    private AliasOfs(ImmutableSetMultimap<ClassName, ClassName> defineComponentScopeToAliases) {
        this.defineComponentScopeToAliases = defineComponentScopeToAliases;
    }

    public ImmutableSet<ClassName> getAliasesFor(ClassName defineComponentScope) {
        return this.defineComponentScopeToAliases.get((Object)defineComponentScope);
    }
}

