/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.auto.value.AutoValue;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.root.AutoValue_Root;
import dagger.hilt.processor.internal.root.RootType;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@AutoValue
abstract class Root {
    Root() {
    }

    static Root createDefaultRoot(ProcessingEnvironment env) {
        TypeElement rootElement = env.getElementUtils().getTypeElement(ClassNames.DEFAULT_ROOT.canonicalName());
        return new AutoValue_Root(rootElement, rootElement, true);
    }

    static Root create(Element element, ProcessingEnvironment env) {
        TypeElement rootElement = MoreElements.asType(element);
        if (ClassNames.DEFAULT_ROOT.equals((Object)ClassName.get((TypeElement)rootElement))) {
            return Root.createDefaultRoot(env);
        }
        return new AutoValue_Root(rootElement, rootElement, RootType.of(rootElement).isTestRoot());
    }

    abstract TypeElement element();

    abstract TypeElement originatingRootElement();

    abstract boolean isTestRoot();

    ClassName classname() {
        return ClassName.get((TypeElement)this.element());
    }

    ClassName originatingRootClassname() {
        return ClassName.get((TypeElement)this.originatingRootElement());
    }

    public final String toString() {
        return this.originatingRootElement().toString();
    }

    boolean isDefaultRoot() {
        return this.classname().equals((Object)ClassNames.DEFAULT_ROOT);
    }
}

