/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.squareup.javapoet.JavaFile;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

final class RootFileFormatter {
    private static final Pattern CLASS_PATERN = Pattern.compile("(\\h*)(.*class.*implements)(.*\\{)");

    static void write(JavaFile javaFile, Filer filer) throws IOException {
        String fileName = javaFile.packageName.isEmpty() ? javaFile.typeSpec.name : javaFile.packageName + "." + javaFile.typeSpec.name;
        Element[] originatingElements = javaFile.typeSpec.originatingElements.toArray(new Element[0]);
        StringBuilder sb = new StringBuilder("");
        javaFile.writeTo((Appendable)sb);
        String fileContent = RootFileFormatter.formatInterfaces(sb.toString(), CLASS_PATERN);
        JavaFileObject filerSourceFile = filer.createSourceFile(fileName, originatingElements);
        try (Writer writer = filerSourceFile.openWriter();){
            writer.write(fileContent);
        }
        catch (Exception e) {
            try {
                filerSourceFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private static String formatInterfaces(String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer(content.length());
        while (matcher.find()) {
            MatchResult result = matcher.toMatchResult();
            String spaces = result.group(1);
            String prefix = result.group(2);
            String interfaces = result.group(3);
            String formattedInterfaces = RootFileFormatter.formatInterfaces(spaces, interfaces);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(spaces + prefix + formattedInterfaces));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String formatInterfaces(String prefixSpaces, String interfaces) {
        StringBuilder sb = new StringBuilder(interfaces);
        String newLine = String.format("\n%s   ", prefixSpaces);
        int i = 0;
        int bracketCount = 0;
        while (i >= 0 && i < sb.length()) {
            char c;
            if ((c = sb.charAt(i++)) == '<') {
                ++bracketCount;
                continue;
            }
            if (c == '>') {
                --bracketCount;
                continue;
            }
            if (c != ',' || bracketCount != 0) continue;
            sb.insert(i++, newLine);
        }
        return sb.toString();
    }

    private RootFileFormatter() {
    }
}

