/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.Generators;
import dagger.hilt.processor.internal.Processors;
import dagger.spi.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeParameterElement;
import java.io.IOException;
import javax.lang.model.element.Modifier;

public final class ActivityGenerator {
    private final XProcessingEnv env;
    private final AndroidEntryPointMetadata metadata;
    private final ClassName generatedClassName;

    public ActivityGenerator(XProcessingEnv env, AndroidEntryPointMetadata metadata) {
        this.env = env;
        this.metadata = metadata;
        this.generatedClassName = metadata.generatedClassName();
    }

    public void generate() throws IOException {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.generatedClassName.simpleName()).superclass(this.metadata.baseClassName()).addModifiers(this.metadata.generatedClassModifiers());
        JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)builder, (XElement)this.metadata.element());
        Generators.addGeneratedBaseClassJavadoc(builder, AndroidClassNames.ANDROID_ENTRY_POINT);
        Processors.addGeneratedAnnotation(builder, this.env, this.getClass());
        Generators.copyConstructors(this.metadata.baseElement(), CodeBlock.builder().addStatement("_initHiltInternal()", new Object[0]).build(), builder);
        builder.addMethod(this.init());
        this.metadata.baseElement().getTypeParameters().stream().map(XTypeParameterElement::getTypeVariableName).forEachOrdered(arg_0 -> ((TypeSpec.Builder)builder).addTypeVariable(arg_0));
        Generators.addComponentOverride(this.metadata, builder);
        Generators.copyLintAnnotations((XElement)this.metadata.element(), builder);
        Generators.copySuppressAnnotations((XElement)this.metadata.element(), builder);
        Generators.addInjectionMethods(this.metadata, builder);
        if (Processors.isAssignableFrom(this.metadata.baseElement(), AndroidClassNames.COMPONENT_ACTIVITY) && !this.metadata.overridesAndroidEntryPointClass()) {
            builder.addMethod(this.getDefaultViewModelProviderFactory());
        }
        this.env.getFiler().write(JavaFile.builder((String)this.generatedClassName.packageName(), (TypeSpec)builder.build()).build(), XFiler.Mode.Isolating);
    }

    private MethodSpec init() {
        return MethodSpec.methodBuilder((String)"_initHiltInternal").addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("addOnContextAvailableListener($L)", new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)AndroidClassNames.ON_CONTEXT_AVAILABLE_LISTENER).addMethod(MethodSpec.methodBuilder((String)"onContextAvailable").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)AndroidClassNames.CONTEXT, "context", new Modifier[0]).addStatement("inject()", new Object[0]).build()).build()}).build();
    }

    private MethodSpec getDefaultViewModelProviderFactory() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getDefaultViewModelProviderFactory").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)AndroidClassNames.VIEW_MODEL_PROVIDER_FACTORY);
        if (this.metadata.allowsOptionalInjection()) {
            builder.beginControlFlow("if (!optionalInjectParentUsesHilt(optionalInjectGetParent()))", new Object[0]).addStatement("return super.getDefaultViewModelProviderFactory()", new Object[0]).endControlFlow();
        }
        return builder.addStatement("return $T.getActivityFactory(this, super.getDefaultViewModelProviderFactory())", new Object[]{AndroidClassNames.DEFAULT_VIEW_MODEL_FACTORIES}).build();
    }
}

