/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.bindvalue;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.Module;
import dagger.Provides;
import dagger.hilt.android.processor.internal.bindvalue.BindValueMetadata;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Components;
import dagger.hilt.processor.internal.Processors;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.multibindings.ElementsIntoSet;
import dagger.multibindings.IntoMap;
import dagger.multibindings.IntoSet;
import dagger.spi.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import java.io.IOException;
import java.util.Comparator;
import javax.lang.model.element.Modifier;

final class BindValueGenerator {
    private static final String SUFFIX = "_BindValueModule";
    private final XProcessingEnv env;
    private final BindValueMetadata metadata;
    private final ClassName testClassName;
    private final ClassName className;

    BindValueGenerator(XProcessingEnv env, BindValueMetadata metadata) {
        this.env = env;
        this.metadata = metadata;
        this.testClassName = metadata.testElement().getClassName();
        this.className = Processors.append(this.testClassName, SUFFIX);
    }

    void generate() throws IOException {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.className);
        JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)builder, (XElement)this.metadata.testElement()).addAnnotation(Processors.getOriginatingElementAnnotation(this.metadata.testElement())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Module.class).addAnnotation(Components.getInstallInAnnotationSpec((ImmutableSet<ClassName>)ImmutableSet.of((Object)ClassNames.SINGLETON_COMPONENT))).addMethod(this.providesTestMethod());
        Processors.addGeneratedAnnotation(builder, this.env, this.getClass());
        this.metadata.bindValueElements().stream().map(this::providesMethod).sorted(Comparator.comparing(MethodSpec::toString)).forEachOrdered(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        this.env.getFiler().write(JavaFile.builder((String)this.className.packageName(), (TypeSpec)builder.build()).build(), XFiler.Mode.Isolating);
    }

    private MethodSpec providesTestMethod() {
        String methodName = "provides" + this.testClassName.simpleName();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addAnnotation(Provides.class).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter(ParameterSpec.builder((TypeName)ClassNames.CONTEXT, (String)"context", (Modifier[])new Modifier[0]).addAnnotation(ClassNames.APPLICATION_CONTEXT).build()).returns((TypeName)this.testClassName).addStatement("return ($T) (($T) (($T) context).componentManager()).getTestInstance()", new Object[]{this.testClassName, ClassNames.TEST_APPLICATION_COMPONENT_MANAGER, ClassNames.TEST_APPLICATION_COMPONENT_MANAGER_HOLDER});
        return builder.build();
    }

    private MethodSpec providesMethod(BindValueMetadata.BindValueElement bindValue) {
        String methodName = "provides" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, bindValue.fieldElement().getName());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addAnnotation(Provides.class).addModifiers(new Modifier[]{Modifier.STATIC}).returns(bindValue.fieldElement().getType().getTypeName());
        if (XElements.isStatic((XElement)bindValue.fieldElement())) {
            builder.addStatement("return $T.$L", new Object[]{this.testClassName, bindValue.fieldElement().getName()});
        } else {
            builder.addParameter((TypeName)this.testClassName, "test", new Modifier[0]).addStatement("return $L", new Object[]{bindValue.getterElement().isPresent() ? CodeBlock.of((String)"test.$L()", (Object[])new Object[]{bindValue.getterElement().get().getJvmName()}) : CodeBlock.of((String)"test.$L", (Object[])new Object[]{bindValue.fieldElement().getName()})});
        }
        ClassName annotationClassName = bindValue.annotationName();
        if (BindValueMetadata.BIND_VALUE_INTO_MAP_ANNOTATIONS.contains((Object)annotationClassName)) {
            builder.addAnnotation(IntoMap.class);
            builder.addAnnotation(XAnnotations.getAnnotationSpec((XAnnotation)bindValue.mapKey().get()));
        } else if (BindValueMetadata.BIND_VALUE_INTO_SET_ANNOTATIONS.contains((Object)annotationClassName)) {
            builder.addAnnotation(IntoSet.class);
        } else if (BindValueMetadata.BIND_ELEMENTS_INTO_SET_ANNOTATIONS.contains((Object)annotationClassName)) {
            builder.addAnnotation(ElementsIntoSet.class);
        }
        bindValue.qualifier().ifPresent(q -> builder.addAnnotation(XAnnotations.getAnnotationSpec((XAnnotation)q)));
        return builder.build();
    }
}

