/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.Generators;
import dagger.hilt.processor.internal.Processors;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XHasModifiers;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeParameterElement;
import java.util.List;

public final class ViewGenerator {
    private final XProcessingEnv env;
    private final AndroidEntryPointMetadata metadata;
    private final ClassName generatedClassName;

    public ViewGenerator(XProcessingEnv env, AndroidEntryPointMetadata metadata) {
        this.env = env;
        this.metadata = metadata;
        this.generatedClassName = metadata.generatedClassName();
    }

    public void generate() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.generatedClassName.simpleName()).superclass(this.metadata.baseClassName()).addModifiers(this.metadata.generatedClassModifiers());
        JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)builder, (XElement)this.metadata.element());
        Generators.addGeneratedBaseClassJavadoc(builder, AndroidClassNames.ANDROID_ENTRY_POINT);
        Processors.addGeneratedAnnotation(builder, this.env, this.getClass());
        Generators.copyLintAnnotations((XElement)this.metadata.element(), builder);
        Generators.copySuppressAnnotations((XElement)this.metadata.element(), builder);
        this.metadata.baseElement().getTypeParameters().stream().map(XTypeParameterElement::getTypeVariableName).forEachOrdered(arg_0 -> ((TypeSpec.Builder)builder).addTypeVariable(arg_0));
        Generators.addComponentOverride(this.metadata, builder);
        Generators.addInjectionMethods(this.metadata, builder);
        this.metadata.baseElement().getConstructors().stream().filter(this::isConstructorVisibleToGeneratedClass).map(this::constructorMethod).forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        this.env.getFiler().write(JavaFile.builder((String)this.generatedClassName.packageName(), (TypeSpec)builder.build()).build(), XFiler.Mode.Isolating);
    }

    private boolean isConstructorVisibleToGeneratedClass(XConstructorElement constructor) {
        if (Processors.hasJavaPackagePrivateVisibility((XHasModifiers)constructor) && !this.isInOurPackage(constructor)) {
            return false;
        }
        return !constructor.isPrivate();
    }

    private MethodSpec constructorMethod(XConstructorElement constructor) {
        MethodSpec.Builder builder = Generators.copyConstructor(constructor).toBuilder();
        if (this.isRestrictedApiConstructor(constructor)) {
            builder.addAnnotation(AnnotationSpec.builder((ClassName)AndroidClassNames.TARGET_API).addMember("value", "21", new Object[0]).build());
        }
        builder.addStatement("inject()", new Object[0]);
        return builder.build();
    }

    private boolean isRestrictedApiConstructor(XConstructorElement constructor) {
        if (constructor.getParameters().size() != 4) {
            return false;
        }
        List constructorParams = constructor.getParameters();
        block6: for (int i = 0; i < constructorParams.size(); ++i) {
            XType type = ((XExecutableParameterElement)constructorParams.get(i)).getType();
            switch (i) {
                case 0: {
                    if (ViewGenerator.isFirstRestrictedParameter(type)) continue block6;
                    return false;
                }
                case 1: {
                    if (ViewGenerator.isSecondRestrictedParameter(type)) continue block6;
                    return false;
                }
                case 2: {
                    if (ViewGenerator.isThirdRestrictedParameter(type)) continue block6;
                    return false;
                }
                case 3: {
                    if (ViewGenerator.isFourthRestrictedParameter(type)) continue block6;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isFourthRestrictedParameter(XType type) {
        return XTypes.isPrimitive((XType)type) && XTypeKt.isInt((XType)type);
    }

    private static boolean isThirdRestrictedParameter(XType type) {
        return XTypes.isPrimitive((XType)type) && XTypeKt.isInt((XType)type);
    }

    private static boolean isSecondRestrictedParameter(XType type) {
        return XTypes.isDeclared((XType)type) && Processors.isAssignableFrom(type.getTypeElement(), AndroidClassNames.ATTRIBUTE_SET);
    }

    private static boolean isFirstRestrictedParameter(XType type) {
        return XTypes.isDeclared((XType)type) && Processors.isAssignableFrom(type.getTypeElement(), AndroidClassNames.CONTEXT);
    }

    private boolean isInOurPackage(XConstructorElement constructor) {
        return constructor.getEnclosingElement().getPackageName().contentEquals(this.metadata.element().getPackageName());
    }
}

