/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.bindvalue;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.processor.internal.bindvalue.BindValueGenerator;
import dagger.hilt.android.processor.internal.bindvalue.BindValueMetadata;
import dagger.hilt.processor.internal.BaseProcessingStep;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XRoundEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.Map;

public final class BindValueProcessingStep
extends BaseProcessingStep {
    private static final ImmutableSet<ClassName> SUPPORTED_ANNOTATIONS = ImmutableSet.builder().addAll(BindValueMetadata.BIND_VALUE_ANNOTATIONS).addAll(BindValueMetadata.BIND_VALUE_INTO_SET_ANNOTATIONS).addAll(BindValueMetadata.BIND_ELEMENTS_INTO_SET_ANNOTATIONS).addAll(BindValueMetadata.BIND_VALUE_INTO_MAP_ANNOTATIONS).build();
    private final ListMultimap<XTypeElement, XElement> testRootMap = ArrayListMultimap.create();

    public BindValueProcessingStep(XProcessingEnv env) {
        super(env);
    }

    @Override
    protected ImmutableSet<ClassName> annotationClassNames() {
        return SUPPORTED_ANNOTATIONS;
    }

    @Override
    protected void preProcess(XProcessingEnv env, XRoundEnv round) {
        this.testRootMap.clear();
    }

    @Override
    public void processEach(ClassName annotation, XElement element) {
        XElement enclosingElement = element.getEnclosingElement();
        ProcessorErrors.checkState(XElementKt.isTypeElement((XElement)enclosingElement) && XElements.asTypeElement((XElement)enclosingElement).isClass() && enclosingElement.hasAnnotation(ClassNames.HILT_ANDROID_TEST), enclosingElement, "@%s can only be used within a class annotated with @HiltAndroidTest. Found: %s", annotation.simpleName(), XElements.toStableString((XElement)enclosingElement));
        this.testRootMap.put((Object)XElements.asTypeElement((XElement)enclosingElement), (Object)element);
    }

    @Override
    protected void postProcess(XProcessingEnv env, XRoundEnv round) throws Exception {
        for (Map.Entry e : this.testRootMap.asMap().entrySet()) {
            BindValueMetadata metadata = BindValueMetadata.create((XTypeElement)e.getKey(), (Collection)e.getValue());
            new BindValueGenerator(this.processingEnv(), metadata).generate();
        }
    }

    static ImmutableList<ClassName> getBindValueAnnotations(XElement element) {
        return (ImmutableList)element.getAllAnnotations().stream().map(XAnnotation::getClassName).filter(arg_0 -> SUPPORTED_ANNOTATIONS.contains(arg_0)).collect(DaggerStreams.toImmutableList());
    }
}

