// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.codeInsight.highlighting;

import ksp.com.intellij.psi.ElementDescriptionLocation;
import ksp.com.intellij.psi.ElementDescriptionProvider;
import ksp.com.intellij.psi.meta.PsiPresentableMetaData;
import ksp.org.jetbrains.annotations.NotNull;


public final class HighlightUsagesDescriptionLocation extends ElementDescriptionLocation {

  private static final ElementDescriptionProvider ourDefaultProvider = (element, location) -> {
    if (element instanceof PsiPresentableMetaData) {
      return ((PsiPresentableMetaData)element).getTypeName();
    }
    return null;
  };

  private HighlightUsagesDescriptionLocation() {
  }

  @Override
  public @NotNull ElementDescriptionProvider getDefaultProvider() {
    return ourDefaultProvider;
  }

  public static final HighlightUsagesDescriptionLocation INSTANCE = new HighlightUsagesDescriptionLocation();
}
