// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.openapi.fileTypes;

import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.extensions.ExtensionPointName;
import ksp.com.intellij.openapi.extensions.KeyedFactoryEPBean;
import ksp.com.intellij.openapi.util.KeyedExtensionFactory;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;

public final class FileTypeExtensionFactory<T> extends KeyedExtensionFactory<T, FileType> {
  public FileTypeExtensionFactory(@NotNull Class<T> interfaceClass, @NonNls @NotNull ExtensionPointName<KeyedFactoryEPBean> epName) {
    super(interfaceClass, epName, ApplicationManager.getApplication());
  }

  @Override
  public @NotNull String getKey(@NotNull FileType key) {
    return key.getName();
  }
}