/*
 * Copyright 2000-2012 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ksp.com.intellij.psi.impl.java.stubs;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.LighterAST;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.psi.PsiAnnotationParameterList;
import ksp.com.intellij.psi.impl.java.stubs.impl.PsiAnnotationParameterListStubImpl;
import ksp.com.intellij.psi.impl.source.BasicJavaElementType;
import ksp.com.intellij.psi.impl.source.tree.java.AnnotationParamListElement;
import ksp.com.intellij.psi.impl.source.tree.java.PsiAnnotationParamListImpl;
import ksp.com.intellij.psi.stubs.*;
import ksp.org.jetbrains.annotations.NotNull;

/**
 * @author Dmitry Avdeev
 */
public class JavaAnnotationParameterListType extends JavaStubElementType<PsiAnnotationParameterListStub, PsiAnnotationParameterList>
  implements EmptyStubSerializer<PsiAnnotationParameterListStub> {

  protected JavaAnnotationParameterListType() {
    super("ANNOTATION_PARAMETER_LIST", true, BasicJavaElementType.BASIC_ANNOTATION_PARAMETER_LIST);
  }

  @Override
  public PsiAnnotationParameterList createPsi(@NotNull ASTNode node) {
    return new PsiAnnotationParamListImpl(node);
  }

  @NotNull
  @Override
  public ASTNode createCompositeNode() {
    return new AnnotationParamListElement();
  }

  @NotNull
  @Override
  public PsiAnnotationParameterListStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement<?> parentStub) {
    return new PsiAnnotationParameterListStubImpl(parentStub);
  }

  @Override
  public PsiAnnotationParameterList createPsi(@NotNull PsiAnnotationParameterListStub stub) {
    return getPsiFactory(stub).createAnnotationParameterList(stub);
  }

  @Override
  public @NotNull PsiAnnotationParameterListStub instantiate(StubElement<?> parentStub) {
    return new PsiAnnotationParameterListStubImpl(parentStub);
  }

  @Override
  public void indexStub(@NotNull PsiAnnotationParameterListStub stub, @NotNull IndexSink sink) {
  }
}
