// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi.impl.source.javadoc;

import ksp.com.intellij.psi.*;
import ksp.com.intellij.psi.javadoc.JavadocTagInfo;
import ksp.com.intellij.psi.javadoc.PsiDocTagValue;

class ReturnDocTagInfo implements JavadocTagInfo {
  @Override
  public String getName() {
    return "return";
  }

  @Override
  public boolean isInline() {
    return false;
  }

  @Override
  public boolean isValidInContext(PsiElement element) {
    if (!(element instanceof PsiMethod)) return false;
    PsiMethod method = (PsiMethod)element;
    final PsiType type = method.getReturnType();
    if (type == null) return false;
    return !PsiTypes.voidType().equals(type);
  }

  @Override
  public String checkTagValue(PsiDocTagValue value) {
    return null;
  }

  @Override
  public PsiReference getReference(PsiDocTagValue value) {
    return null;
  }
}