// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.psi.tree.java;

import ksp.com.intellij.lang.java.JavaLanguage;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NonNls;

public class IJavaElementType extends IElementType {
  private final boolean myLeftBound;

  public IJavaElementType(@NonNls final String debugName) {
    this(debugName, false);
  }

  public IJavaElementType(@NonNls final String debugName, final boolean leftBound) {
    super(debugName, JavaLanguage.INSTANCE);
    myLeftBound = leftBound;
  }

  @Override
  public boolean isLeftBound() {
    return myLeftBound;
  }
}