/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.components

import ksp.org.jetbrains.kotlin.analysis.api.KaContextParameterApi
import ksp.org.jetbrains.kotlin.analysis.api.KaExperimentalApi
import ksp.org.jetbrains.kotlin.analysis.api.KaImplementationDetail
import ksp.org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaModule
import ksp.org.jetbrains.kotlin.analysis.api.scopes.KaScope

/**
 * Provides declarations generated by compiler plugins.
 */
@KaExperimentalApi
@SubclassOptInRequired(KaImplementationDetail::class)
public interface KaCompilerPluginGeneratedDeclarationsProvider : KaSessionComponent {
    /**
     * [Declarations][KaCompilerPluginGeneratedDeclarations] generated by compiler plugins for [this] module, not including the generated
     * declarations for *dependencies* of this module.
     */
    @KaExperimentalApi
    public val KaModule.compilerPluginGeneratedDeclarations: KaCompilerPluginGeneratedDeclarations
}

/**
 * Represents declarations generated by compiler plugins.
 *
 * @see KaCompilerPluginGeneratedDeclarationsProvider
 */
@KaExperimentalApi
@SubclassOptInRequired(KaImplementationDetail::class)
public interface KaCompilerPluginGeneratedDeclarations : KaLifetimeOwner {
    /**
     * A [KaScope] containing the top-level declarations generated by compiler plugins.
     */
    public val topLevelDeclarationsScope: KaScope
}

/**
 * @see KaCompilerPluginGeneratedDeclarationsProvider.compilerPluginGeneratedDeclarations
 */
@KaContextParameterApi
@KaExperimentalApi
context(context: KaCompilerPluginGeneratedDeclarationsProvider)
public val KaModule.compilerPluginGeneratedDeclarations: KaCompilerPluginGeneratedDeclarations
    get() = with(context) { compilerPluginGeneratedDeclarations }
