/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.fir.symbols.pointers

import ksp.org.jetbrains.kotlin.analysis.api.fir.KaFirSession
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaKotlinPropertySymbol
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaSymbol
import ksp.org.jetbrains.kotlin.analysis.api.symbols.pointers.KaSymbolPointer
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.providers.FirCallableSignature
import ksp.org.jetbrains.kotlin.fir.FirSession
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol
import ksp.org.jetbrains.kotlin.name.CallableId

internal class KaFirTopLevelPropertySymbolPointer(
    callableId: CallableId,
    private val signature: FirCallableSignature,
    originalSymbol: KaKotlinPropertySymbol?,
) : KaTopLevelCallableSymbolPointer<KaKotlinPropertySymbol>(callableId, originalSymbol) {
    override fun KaFirSession.chooseCandidateAndCreateSymbol(
        candidates: Collection<FirCallableSymbol<*>>,
        firSession: FirSession,
    ): KaKotlinPropertySymbol? {
        val firProperty = candidates.findDeclarationWithSignatureBySymbols<FirProperty>(signature) ?: return null
        return firSymbolBuilder.variableBuilder.buildPropertySymbol(firProperty.symbol) as? KaKotlinPropertySymbol
    }

    override fun pointsToTheSameSymbolAs(other: KaSymbolPointer<KaSymbol>): Boolean = this === other ||
            other is KaFirTopLevelPropertySymbolPointer &&
            other.signature == signature &&
            hasTheSameOwner(other)
}
