/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.fir.types

import ksp.org.jetbrains.kotlin.fir.FirSession
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType
import ksp.org.jetbrains.kotlin.fir.types.typeApproximator
import ksp.org.jetbrains.kotlin.types.TypeApproximatorConfiguration
import ksp.org.jetbrains.kotlin.types.model.KotlinTypeMarker
import ksp.org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext

internal object PublicTypeApproximator {
    fun approximateToDenotableSupertype(
        type: ConeKotlinType,
        session: FirSession,
        approximateLocalTypes: Boolean,
        shouldApproximateLocalType: (TypeSystemInferenceExtensionContext, KotlinTypeMarker) -> Boolean,
    ): ConeKotlinType? {
        val approximator = session.typeApproximator
        return approximator.approximateToSuperType(type, PublicApproximatorConfiguration(approximateLocalTypes, shouldApproximateLocalType))
    }

    fun approximateToDenotableSubtype(
        type: ConeKotlinType,
        session: FirSession,
    ): ConeKotlinType? {
        val approximator = session.typeApproximator
        return approximator.approximateToSubType(type, PublicApproximatorConfiguration())
    }

    internal class PublicApproximatorConfiguration(
        override val approximateLocalTypes: Boolean = false,
        private val shouldApproximateLocalType: (TypeSystemInferenceExtensionContext, KotlinTypeMarker) -> Boolean = { _, _ -> true }
    ) : TypeApproximatorConfiguration() {
        override fun shouldApproximateLocalType(ctx: TypeSystemInferenceExtensionContext, type: KotlinTypeMarker): Boolean =
            shouldApproximateLocalType.invoke(ctx, type)

        override val approximateAllFlexible: Boolean get() = true
        override val approximateErrorTypes: Boolean get() = false
        override val approximateDefinitelyNotNullTypes: Boolean get() = true
        override val approximateIntegerLiteralConstantTypes: Boolean get() = true
        override val approximateIntersectionTypesInContravariantPositions: Boolean get() = true
        override val approximateAnonymous: Boolean get() = true
    }
}
