/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.backend.jvm

import ksp.org.jetbrains.kotlin.backend.jvm.lower.SingletonObjectJvmStaticTransformer
import ksp.org.jetbrains.kotlin.backend.jvm.serialization.deserializeFromByteArray
import ksp.org.jetbrains.kotlin.ir.IrBuiltIns
import ksp.org.jetbrains.kotlin.ir.IrProvider
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass
import ksp.org.jetbrains.kotlin.ir.util.SymbolTable
import ksp.org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement

class JvmIrDeserializerImpl : JvmIrDeserializer {
    override fun deserializeTopLevelClass(
        irClass: IrClass,
        irBuiltIns: IrBuiltIns,
        symbolTable: SymbolTable,
        irProviders: List<IrProvider>,
        extensions: JvmGeneratorExtensions,
    ): Boolean {
        val serializedIr = when (val source = irClass.source) {
            is KotlinJvmBinarySourceElement -> source.binaryClass.classHeader.serializedIr
            is JvmPackagePartSource -> source.knownJvmBinaryClass?.classHeader?.serializedIr
            else -> null
        } ?: return false
        deserializeFromByteArray(
            serializedIr, irBuiltIns, symbolTable, irProviders, irClass, JvmIrTypeSystemContext(irBuiltIns)
        )

        irClass.transform(SingletonObjectJvmStaticTransformer(irBuiltIns, extensions.cachedFields), null)

        return true
    }
}
