/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.psi.stubs.elements;

import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.psi.stubs.StubInputStream;
import ksp.com.intellij.psi.stubs.StubOutputStream;
import ksp.com.intellij.util.io.StringRef;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameter;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinTypeParameterStub;
import ksp.org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeParameterStubImpl;

import java.io.IOException;

public class KtTypeParameterElementType extends KtStubElementType<KotlinTypeParameterStubImpl, KtTypeParameter> {
    public KtTypeParameterElementType(@NotNull @NonNls String debugName) {
        super(debugName, KtTypeParameter.class, KotlinTypeParameterStub.class);
    }

    @NotNull
    @Override
    public KotlinTypeParameterStubImpl createStub(@NotNull KtTypeParameter psi, StubElement parentStub) {
        return new KotlinTypeParameterStubImpl(
                (StubElement<?>) parentStub, StringRef.fromString(psi.getName())
        );
    }

    @Override
    public void serialize(@NotNull KotlinTypeParameterStubImpl stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
    }

    @NotNull
    @Override
    public KotlinTypeParameterStubImpl deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        return new KotlinTypeParameterStubImpl((StubElement<?>) parentStub, name);
    }
}
