// Copyright 2000-2022 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.openapi.vfs.pointers;

import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

/**
 * A pointer to a {@link VirtualFile}.
 *
 * @see VirtualFilePointerManager#create
 * @see VirtualFilePointerContainer
 */
public interface VirtualFilePointer {
  VirtualFilePointer[] EMPTY_ARRAY = new VirtualFilePointer[0];

  @NotNull
  String getFileName();

  @Nullable
  VirtualFile getFile();

  @NotNull
  @NonNls String getUrl();

  @NlsSafe @NotNull String getPresentableUrl();

  /**
   * @return true if the file exists
   */
  boolean isValid();
}
