// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

package ksp.com.intellij.psi.impl;

import ksp.com.intellij.openapi.extensions.ProjectExtensionPointName;
import ksp.org.jetbrains.annotations.NotNull;

/**
 * An extension called before notifying {@link com.intellij.psi.PsiTreeChangeListener}s of events.<p></p>
 * <p>
 * Try to avoid processing PSI events at all cost! See {@link com.intellij.psi.PsiTreeChangeEvent} documentation for more details.
 */
public interface PsiTreeChangePreprocessor {
  ProjectExtensionPointName<PsiTreeChangePreprocessor> EP = new ProjectExtensionPointName<>("com.intellij.psi.treeChangePreprocessor");

  void treeChanged(@NotNull PsiTreeChangeEventImpl event);
}
