/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.impl.base.projectStructure

import ksp.com.intellij.openapi.project.Project
import ksp.com.intellij.psi.search.GlobalSearchScope
import ksp.org.jetbrains.kotlin.analysis.api.KaImplementationDetail
import ksp.org.jetbrains.kotlin.analysis.api.KaPlatformInterface
import ksp.org.jetbrains.kotlin.analysis.api.platform.projectStructure.KaModuleBase
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaBuiltinsModule
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaModule
import ksp.org.jetbrains.kotlin.analysis.decompiler.psi.BuiltinsVirtualFileProvider
import ksp.org.jetbrains.kotlin.platform.TargetPlatform

@KaPlatformInterface
@KaImplementationDetail
class KaBuiltinsModuleImpl(
    override val targetPlatform: TargetPlatform,
    override val project: Project,
) : KaBuiltinsModule, KaModuleBase() {
    override val baseContentScope: GlobalSearchScope
        get() = BuiltinsVirtualFileProvider.getInstance().createBuiltinsScope(project)

    override fun equals(other: Any?): Boolean = other is KaBuiltinsModule && this.targetPlatform == other.targetPlatform
    override fun hashCode(): Int = targetPlatform.hashCode()
    override val transitiveDependsOnDependencies: List<KaModule> get() = emptyList()
}