/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.backend.konan

import ksp.org.jetbrains.kotlin.backend.common.PreSerializationLoweringContext
import ksp.org.jetbrains.kotlin.backend.common.ir.KlibSharedVariablesManager
import ksp.org.jetbrains.kotlin.backend.common.ir.PreSerializationNativeSymbols
import ksp.org.jetbrains.kotlin.config.CompilerConfiguration
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.ir.IrBuiltIns

class NativePreSerializationLoweringContext(
        irBuiltIns: IrBuiltIns,
        configuration: CompilerConfiguration,
        diagnosticReporter: DiagnosticReporter,
) : PreSerializationLoweringContext(irBuiltIns, configuration, diagnosticReporter) {
    override val symbols: PreSerializationNativeSymbols = PreSerializationNativeSymbols.Impl(irBuiltIns)

    override val sharedVariablesManager = KlibSharedVariablesManager(symbols)

    override val allowInliningOfExternalFunctions: Boolean
        get() = false
}
