/*
 * Copyright 2010-2019 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.backend.wasm.lower

import ksp.org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmSignature
import ksp.org.jetbrains.kotlin.backend.wasm.ir2wasm.wasmSignature
import ksp.org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext
import ksp.org.jetbrains.kotlin.ir.backend.js.lower.BridgesConstruction
import ksp.org.jetbrains.kotlin.ir.backend.js.utils.realOverrideTarget
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction
import ksp.org.jetbrains.kotlin.ir.util.isEffectivelyExternal

class WasmBridgesConstruction(val context: JsCommonBackendContext) : BridgesConstruction(context) {
    override fun getFunctionSignature(function: IrSimpleFunction): WasmSignature =
        function.wasmSignature(context.irBuiltIns)

    override fun findConcreteSuperDeclaration(function: IrSimpleFunction): IrSimpleFunction =
        function.realOverrideTarget

    // Dispatch receiver type must be casted when types are different.
    override val shouldCastDispatchReceiver: Boolean = true
    override fun getBridgeOrigin(bridge: IrSimpleFunction): IrDeclarationOrigin =
        IrDeclarationOrigin.BRIDGE

    override fun transformFlat(declaration: IrDeclaration): List<IrDeclaration>? {
        if (declaration.isEffectivelyExternal()) return null
        return super.transformFlat(declaration)
    }
}