/*
 * Copyright 2010-2020 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.descriptors.konan

import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor
import ksp.org.jetbrains.kotlin.descriptors.ModuleDescriptor
import ksp.org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor
import ksp.org.jetbrains.kotlin.konan.library.KONAN_STDLIB_NAME
import ksp.org.jetbrains.kotlin.name.NativeForwardDeclarationKind
import ksp.org.jetbrains.kotlin.name.Name

val NATIVE_STDLIB_MODULE_NAME: Name = Name.special("<$KONAN_STDLIB_NAME>")

fun ModuleDescriptor.isNativeStdlib(): Boolean = name == NATIVE_STDLIB_MODULE_NAME

fun ClassDescriptor.getForwardDeclarationKindOrNull(): NativeForwardDeclarationKind? =
    NativeForwardDeclarationKind.packageFqNameToKind[(containingDeclaration as? PackageFragmentDescriptor)?.fqName]