/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.ir.validation.checkers.symbol

import ksp.org.jetbrains.kotlin.ir.IrElement
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol
import ksp.org.jetbrains.kotlin.ir.validation.checkers.IrSymbolChecker
import ksp.org.jetbrains.kotlin.ir.validation.checkers.checkVisibility
import ksp.org.jetbrains.kotlin.ir.validation.checkers.context.CheckerContext

object IrVisibilityChecker : IrSymbolChecker {
    override fun check(
        symbol: IrSymbol,
        container: IrElement,
        context: CheckerContext,
    ) {
        // FIXME: KT-80071
        if (context.withinScripOrScriptClass)
            return

        checkVisibility(symbol, container, context)
    }
}