/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.psi.stubs.impl;

import ksp.com.intellij.psi.stubs.StubElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.psi.KtDeclarationModifierList;
import ksp.org.jetbrains.kotlin.psi.KtImplementationDetail;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinModifierListStub;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KotlinModifierListStubImpl extends KotlinStubBaseImpl<KtDeclarationModifierList> implements KotlinModifierListStub {

    private final long mask;

    public KotlinModifierListStubImpl(@Nullable StubElement<?> parent, long mask) {
        super(parent, KtStubElementTypes.MODIFIER_LIST);
        this.mask = mask;
    }

    public long getMask() {
        return mask;
    }

    @Override
    public boolean hasModifier(@NotNull KtModifierKeywordToken modifierToken) {
        return ModifierMaskUtils.maskHasModifier(mask, modifierToken);
    }

    @Override
    public boolean hasSpecialFlag(@NotNull SpecialFlag flag) {
        return ModifierMaskUtils.maskHasSpecialFlag(mask, flag);
    }

    @NotNull
    @Override
    public String toString() {
        return super.toString() + ModifierMaskUtils.maskToString(mask);
    }

    public boolean hasAnyModifier() {
        return mask != 0;
    }

    @Override
    @KtImplementationDetail
    public @NotNull KotlinModifierListStubImpl copyInto(@Nullable StubElement<?> newParent) {
        return new KotlinModifierListStubImpl(
                newParent,
                mask
        );
    }
}
