/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ksp.com.intellij.core;

import ksp.com.intellij.openapi.application.ModalityState;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.psi.FileViewProvider;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.impl.DocumentCommitProcessor;
import ksp.com.intellij.psi.impl.PsiDocumentManagerBase;
import ksp.org.jetbrains.annotations.NotNull;

class MockDocumentCommitProcessor implements DocumentCommitProcessor {
  @Override
  public void commitSynchronously(@NotNull Document document, @NotNull Project project, @NotNull PsiFile psiFile) {
  }

  @Override
  public void commitAsynchronously(@NotNull Project project,
                                   @NotNull PsiDocumentManagerBase documentManager,
                                   @NotNull Document document,
                                   @NotNull Object reason,
                                   @NotNull ModalityState modality,
                                   @NotNull FileViewProvider cachedViewProvider) {

  }
}
