// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.pom.event;

import ksp.com.intellij.pom.PomModel;
import ksp.com.intellij.pom.PomModelAspect;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.EventObject;
import java.util.Set;

public class PomModelEvent extends EventObject {
  private PomChangeSet myChangeSet;

  @ApiStatus.Internal
  public PomModelEvent(@NotNull PomModel source, @Nullable PomChangeSet changeSet) {
    super(source);
    myChangeSet = changeSet;
  }

  public @NotNull Set<PomModelAspect> getChangedAspects() {
    if (myChangeSet != null) {
      return Collections.singleton(myChangeSet.getAspect());
    }
    else {
      return Collections.emptySet();
    }
  }

  public PomChangeSet getChangeSet(@NotNull PomModelAspect aspect) {
    return myChangeSet == null || !aspect.equals(myChangeSet.getAspect()) ? null : myChangeSet;
  }

  public void merge(@NotNull PomModelEvent event) {
    if (event.myChangeSet != null && myChangeSet != null) {
      myChangeSet.merge(event.myChangeSet);
    } else if (myChangeSet == null) {
      myChangeSet = event.myChangeSet;
    }
  }

  @Override
  public PomModel getSource() {
    return (PomModel)super.getSource();
  }

  public void beforeNestedTransaction() {
    if (myChangeSet != null) {
      myChangeSet.beforeNestedTransaction();
    }
  }
}
