/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.platform.packages

import ksp.com.intellij.openapi.components.service
import ksp.com.intellij.openapi.project.Project
import ksp.com.intellij.psi.search.GlobalSearchScope
import ksp.org.jetbrains.kotlin.analysis.api.platform.KotlinPlatformComponent
import ksp.org.jetbrains.kotlin.load.kotlin.PackagePartProvider

public interface KotlinPackagePartProviderFactory : KotlinPlatformComponent {
    /**
     * Create a [PackagePartProvider] for a given scope. [PackagePartProvider] is responsible for searching sub packages in a library.
     */
    public fun createPackagePartProvider(scope: GlobalSearchScope): PackagePartProvider

    public companion object {
        public fun getInstance(project: Project): KotlinPackagePartProviderFactory = project.service()
    }
}

/**
 * Create a [PackagePartProvider] for a given scope. [PackagePartProvider] is responsible for searching sub packages in a library.
 */
public fun Project.createPackagePartProvider(scope: GlobalSearchScope): PackagePartProvider =
    KotlinPackagePartProviderFactory.getInstance(this).createPackagePartProvider(scope)
